package com.xith.java3d.testbed;

import java.applet.*;
import javax.swing.*;
import java.awt.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.*;
import com.sun.j3d.utils.universe.*;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;

/**
 * Basic testbed platform for Java3d.
 * Copyright:    Copyright (c) 2000,2001
 * Company:      Teseract Software, LLP
 * @author David Yazel
 * @version
 */

public class TestBed extends Applet
{


    public Canvas3D canvas;
    public ViewingPlatform vp;
    public BranchGroup scene;
    public SimpleUniverse u = null;


    /**
     * Override to add new items to the scene
     */
    public void addNodes(BranchGroup bg) {

    }

    public BranchGroup createSceneGraph(Canvas3D c)
    {

        BranchGroup objRoot = new BranchGroup();

        // Create a bounds for the background and behaviors
        BoundingSphere bounds =
            new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);

        // Set up the background
        Color3f bgColor = new Color3f(0.15f, 0.15f, 0.6f);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds(bounds);
        objRoot.addChild(bg);
        addNodes(objRoot);
        objRoot.compile();

        return objRoot;
    }


    public void init()
    {
        setLayout(new BorderLayout());
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();

        GraphicsConfiguration config = GraphicsEnvironment.getLocalGraphicsEnvironment().
                getDefaultScreenDevice().getBestConfiguration(template);
        canvas = new Canvas3D(config);
        add(BorderLayout.CENTER, canvas);
        this.validate();

        u = new SimpleUniverse(canvas);
        u.getViewingPlatform().setNominalViewingTransform();
        vp = u.getViewingPlatform();
        scene = createSceneGraph(canvas);
        u.addBranchGraph(scene);
        OrbitBehavior orbit = new OrbitBehavior(canvas);
        orbit.setMinRadius(20);
        orbit.setSchedulingBounds(new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0));
        u.getViewingPlatform().setViewPlatformBehavior(orbit);

        Transform3D t = new Transform3D();
        t.lookAt(new Point3d(20,0,20),new Point3d(0,0,0),new Vector3d(0,1,0));
        t.invert();
        vp.getViewPlatformTransform().setTransform(t);
    }

    public void destroy()
    {
        u.removeAllLocales();
    }

    public static void main(String[] args) throws Exception
    {
        new MainFrame(new TestBed(), 600, 600);
    }

}
