package com.xith.java3d.overlay;

import com.xith.java3d.testbed.*;
import java.applet.*;
import javax.swing.*;
import java.awt.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.utils.applet.MainFrame;
import com.xith.client.gui.*;

/**
 * Title:        Simple applet to test various overlay implementations
 * Description:
 * Copyright:    Copyright (c) 2000,2001
 * Company:      Teseract Software, LLP
 * @author David Yazel
 * @version
 */

public class OverlayTester extends TestBed{

   public void addNodes( BranchGroup bg ) {

      // add a simple FPS counter

      Overlay fps = new FpsOverlay(canvas,vp.getViewPlatformTransform(),80,20,false,true);
      fps.setPosition(10,10);
      fps.setVisible(true);

      // test to make sure two adjecent overlays touch

      Overlay top = new Overlay(canvas,vp.getViewPlatformTransform(),70,70,false,true);
      top.setBackgroundColor(new Color(0f,1f,0f,0.3f));
      top.setPosition(600-70-1,600-70-1);
      top.repaint();
      top.setVisible(true);

      /*
      Overlay bottom = new Overlay(canvas,vp.getViewPlatformTransform(),35,35,false,true);
      bottom.setBackgroundColor(new Color(1f,0f,0f,0.3f));
      bottom.setPosition(10,90);
      bottom.repaint();
      bottom.setVisible(true);
      */

      // add a simple scrolling overlay

      ChatOverlay s = new ChatOverlay(canvas,vp.getViewPlatformTransform(),500,9);
      s.runTest();
      s.setPosition(50,200);
      s.setVisible(true);


   }

   public static void main(String[] args) throws Exception
    {
        new MainFrame(new OverlayTester(), 600, 600);
    }

}