package com.xith.java3d.overlay;

/**
 * $Id$
 *
 * $Log$
 */
import javax.media.j3d.*;
import javax.vecmath.*;
import java.awt.*;
import java.awt.image.*;
import java.util.*;

/**
 * This test overlay puts a FPS counter on the screen and updates it frequently
 *
 * Copyright:  Copyright (c) 2000,2001
 * Company:    Teseract Software, LLP
 * @author David Yazel
 *
 */

public class FpsOverlay extends Overlay {

   FramesPerSecond fpsBehavior;
   Font font;
   public FpsOverlay(Canvas3D c, TransformGroup viewTG, int width, int height, boolean clipAlpha, boolean blendAlpha) {

      super(c,viewTG,width,height,clipAlpha,blendAlpha);

   }

   public void initialize() {
      font = new java.awt.Font("Dialog", Font.BOLD, 14);

      fpsBehavior = new FramesPerSecond();
      fpsBehavior.setSchedulingBounds(new BoundingSphere(new Point3d(0,0,0),10000));
      attachNode(fpsBehavior);

      // set the entire background to transparent

      setBackgroundColor(new Color(0.0f,0.0f,0.0f,0.0f));

   }

   public void paint(Graphics2D g) {

      // how about a nice green for the FPS :)

      g.setColor(new Color(0.0f,1.0f,0.0f,1.0f));
      g.setFont(font);
      g.drawString("FPS: "+fpsBehavior.fps,2,height-2);

   }

   public class FramesPerSecond extends Behavior {

      public long fps;
      long startTime;
      public long frames;

      WakeupCriterion criterion = null;

      public FramesPerSecond() {

         setSchedulingBounds(new BoundingSphere());
         startTime = System.currentTimeMillis();
         frames = 0;
      }


      public void initialize(){
         criterion = new WakeupOnElapsedTime(1000);
         wakeupOn(criterion);
      }

      public void processStimulus(Enumeration criteria) {

         long elapsedTime = System.currentTimeMillis()-startTime;
         if (elapsedTime>0) {
            long frame = getView().getFrameNumber();
            fps = (frame-frames) * 1000 / elapsedTime;
            System.out.println("fps "+fps);
            startTime = System.currentTimeMillis();
            frames = frame;
         }
         repaint();
         wakeupOn(criterion);

      }

   }
}