package com.xith.java3d.overlay;

import java.awt.*;
import java.awt.image.*;
import java.awt.color.*;

/**
 *
 *
 * Copyright:  Copyright (c) 2000,2001
 * Company:    Teseract Software, LLP
 * @author David Yazel
 *
 */

public class CustomBufferedImage {


   public static BufferedImage getCustomRGB (int width, int height) {

    ColorSpace cs = ColorSpace.getInstance(ColorSpace.CS_sRGB);
    int[] nBits = {8, 8, 8};
    ColorModel cm = new ComponentColorModel(cs, nBits, false, false,
                   Transparency.OPAQUE, 0);
    int[] bandOffset = {0, 1, 2};

    WritableRaster newRaster =
      Raster.createInterleavedRaster(DataBuffer.TYPE_BYTE, width, height,
                 width*3, 3, bandOffset, null);
    BufferedImage newImage = new BufferedImage(cm, newRaster, false, null);
    return newImage;

  }

  public static BufferedImage getCustomRGBA(int width, int height) {

    ColorSpace cs = ColorSpace.getInstance(ColorSpace.CS_sRGB);
    int[] nBits = {8, 8, 8, 8};
    ColorModel cm = new ComponentColorModel(cs, nBits, true, false,
                   Transparency.OPAQUE, 0);
    int[] bandOffset = {0, 1, 2, 3};

    WritableRaster newRaster =
      Raster.createInterleavedRaster(DataBuffer.TYPE_BYTE, width, height,
                 width*4, 4, bandOffset, null);
    BufferedImage newImage = new BufferedImage(cm, newRaster, false, null);
    return newImage;
  }

}

