/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTTransformer
implements Runnable {
    List<XMLFilter> filters = new ArrayList<XMLFilter>();
    InputSource source;
    Result result;
    SAXTransformerFactory transFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();

    public void setSource(String string) throws FileNotFoundException {
        this.setSource(new InputSource(new FileInputStream(string)));
    }

    public void setSource(InputSource inputSource) {
        this.source = inputSource;
    }

    public InputSource getSource() {
        if (this.source == null) {
            this.source = new InputSource(System.in);
        }
        return this.source;
    }

    public void setResult(String string) throws FileNotFoundException {
        this.setResult(new StreamResult(new FileOutputStream(string)));
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Result getResult() {
        if (this.result == null) {
            this.result = new StreamResult(System.out);
        }
        return this.result;
    }

    public void addTransform(String string) throws TransformerConfigurationException {
        this.addTransform(this.transFactory.newXMLFilter(new StreamSource(string)));
    }

    public void addTransform(String string, Map<String, String> map) throws TransformerConfigurationException {
        XMLFilter xMLFilter = this.transFactory.newXMLFilter(new StreamSource(string));
        if (map != null && map.size() > 0) {
            try {
                Method method = xMLFilter.getClass().getMethod("getTransformer", new Class[0]);
                Transformer transformer = (Transformer)method.invoke((Object)xMLFilter, new Object[0]);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    transformer.setParameter(entry.getKey(), entry.getValue());
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("No Method getTransformer(): Cannot set parameters for: " + string);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Invocation Exception on getTransformer(): Cannot set parameters for: " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Illegal Access: Cannot set parameters for: " + string);
            }
        }
        this.addTransform(xMLFilter);
    }

    public void addTransform(XMLFilter xMLFilter) {
        this.filters.add(xMLFilter);
    }

    public void process() throws TransformerConfigurationException, TransformerException {
        SAXSource sAXSource = new SAXSource(this.getSource());
        XMLFilter xMLFilter = null;
        for (XMLFilter xMLFilter2 : this.filters) {
            if (xMLFilter == null) {
                sAXSource.setXMLReader(xMLFilter2);
            } else {
                xMLFilter2.setParent(xMLFilter);
            }
            xMLFilter = xMLFilter2;
        }
        Transformer transformer = this.transFactory.newTransformer();
        transformer.transform(sAXSource, this.getResult());
    }

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        XSLTTransformer xSLTTransformer = new XSLTTransformer();
        if (stringArray.length < 2) {
            System.out.println("Java partial clone of the xsltproc utility.\n\nUsage: " + xSLTTransformer.getClass().getName() + " ([args] [xslt])* (<source> | -)\n\n" + "Arguments:\n" + "  (--param | --stringparam) <key> <value>\n" + "  (-o | --output) (<filename> | -)\n\n" + "Multiple output files and output to a directory is not supported.\n\n" + "Unlike the original, multiple stylesheets may be specified and will be chained.\n" + "If there are multiple styles, the paramters will be cleared each time a new\n" + "stylesheet is added, so a stylesheets parameters must occur before the stylesheet.");
        } else {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (stringArray[i].equals("--param") || stringArray[i].equals("--stringparam") || stringArray[i].equals("-stringparam")) {
                    hashMap.put(stringArray[++i], stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-o") || stringArray[i].equals("--output")) {
                    String string;
                    if ((string = stringArray[++i]) == "-") {
                        string = null;
                    }
                    xSLTTransformer.setResult(string);
                    continue;
                }
                xSLTTransformer.addTransform(stringArray[i], hashMap);
                hashMap.clear();
            }
            if (!stringArray[stringArray.length - 1].equals("-")) {
                xSLTTransformer.setSource(stringArray[stringArray.length - 1]);
            }
            xSLTTransformer.process();
        }
    }
}

