/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.j3d.test;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Locale;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.himinbi.j3d.test.StatedCanvas3D;

public class TranslationTest
extends JApplet
implements AdjustmentListener,
ChangeListener,
KeyListener {
    JScrollBar zoomBar = new JScrollBar(0);
    JScrollBar[] speedBar = new JScrollBar[3];
    String[] labelText = new String[3];
    Alpha[] rotationAlpha = new Alpha[3];
    JCheckBox[] pause = new JCheckBox[3];
    RotationInterpolator[] rotator = new RotationInterpolator[3];
    StatedCanvas3D canvas;
    Transform3D orbitTransform;
    TransformGroup orbitTranslation;

    public TranslationTest() {
        this(false);
    }

    public TranslationTest(boolean bl) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.canvas = new StatedCanvas3D(SimpleUniverse.getPreferredConfiguration());
        this.canvas.addChangeListener(this);
        this.canvas.addKeyListener(this);
        gridBagLayout.setConstraints((Component)((Object)this.canvas), gridBagConstraints);
        this.getContentPane().add((Component)((Object)this.canvas));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        JLabel jLabel = new JLabel("Distance");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.getContentPane().add(jLabel);
        gridBagConstraints.gridwidth = 0;
        this.zoomBar.addAdjustmentListener(this);
        gridBagLayout.setConstraints(this.zoomBar, gridBagConstraints);
        this.getContentPane().add(this.zoomBar);
        int n = 0;
        this.labelText[n++] = new String("Earth Speed");
        this.labelText[n++] = new String("Orbit Speed");
        this.labelText[n++] = new String("Body Speed");
        n = 0;
        int[] nArray = new int[3];
        nArray[n++] = 8500;
        nArray[n++] = 9300;
        nArray[n++] = 6000;
        for (n = 0; n < this.labelText.length; ++n) {
            gridBagConstraints.gridwidth = 1;
            jLabel = new JLabel(this.labelText[n]);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.getContentPane().add(jLabel);
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.weightx = 1.0;
            this.speedBar[n] = new JScrollBar(0);
            this.speedBar[n].setMinimum(1);
            this.speedBar[n].setMaximum(10000);
            this.speedBar[n].setValue(nArray[n]);
            this.speedBar[n].addAdjustmentListener(this);
            this.speedBar[n].addKeyListener(this);
            gridBagLayout.setConstraints(this.speedBar[n], gridBagConstraints);
            this.getContentPane().add(this.speedBar[n]);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 0.0;
            this.pause[n] = new JCheckBox("paused", false);
            this.pause[n].addChangeListener(this);
            this.pause[n].addKeyListener(this);
            gridBagLayout.setConstraints(this.pause[n], gridBagConstraints);
            this.getContentPane().add(this.pause[n]);
        }
        this.setupScene(bl);
    }

    private void setupScene(boolean bl) {
        TextureLoader textureLoader;
        String string;
        float f = 1.0f;
        float f2 = 0.05f;
        float f3 = 4.0f * f;
        this.zoomBar.setMinimum((int)f3);
        this.zoomBar.setMaximum(6000000);
        this.zoomBar.setValue((int)(f3 * 2.0f));
        View view = new View();
        view.setPhysicalBody(new PhysicalBody());
        view.setPhysicalEnvironment(new PhysicalEnvironment());
        view.setBackClipDistance(10000.0);
        view.addCanvas3D((Canvas3D)this.canvas);
        ViewPlatform viewPlatform = new ViewPlatform();
        view.attachViewPlatform(viewPlatform);
        VirtualUniverse virtualUniverse = new VirtualUniverse();
        Locale locale = new Locale(virtualUniverse);
        BranchGroup branchGroup = new BranchGroup();
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
        Background background = new Background(new Color3f(0.11372549f, 0.16862746f, 0.6f));
        background.setApplicationBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)background);
        DirectionalLight directionalLight = new DirectionalLight(new Color3f(0.39215687f, 0.39215687f, 0.39215687f), new Vector3f(-1.0f, -1.0f, -1.0f));
        directionalLight.setInfluencingBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)directionalLight);
        TransformGroup[] transformGroupArray = new TransformGroup[this.rotator.length];
        for (int i = 0; i < this.rotator.length; ++i) {
            transformGroupArray[i] = new TransformGroup();
            transformGroupArray[i].setCapability(17);
            transformGroupArray[i].setCapability(18);
            this.rotationAlpha[i] = new Alpha(-1, 1, 0L, 0L, (long)this.speedBar[i].getValue(), 0L, 0L, 0L, 0L, 0L);
            this.rotator[i] = new RotationInterpolator(this.rotationAlpha[i], transformGroupArray[i], new Transform3D(), 0.0f, (float)Math.PI * 2);
            this.rotator[i].setSchedulingBounds((Bounds)boundingSphere);
            transformGroupArray[i].addChild((Node)this.rotator[i]);
        }
        branchGroup.addChild((Node)transformGroupArray[0]);
        Color3f color3f = new Color3f(0.14901961f, 0.8980392f, 1.0f);
        Color3f color3f2 = new Color3f(0.98039216f, 0.047058824f, 0.047058824f);
        Color3f color3f3 = new Color3f(0.1882353f, 0.46666667f, 0.16078432f);
        Color3f color3f4 = new Color3f(0.16470589f, 0.05490196f, 0.22745098f);
        Color3f color3f5 = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f color3f6 = new Color3f(1.0f, 1.0f, 1.0f);
        Appearance appearance = new Appearance();
        appearance.setMaterial(new Material(color3f5, color3f4, color3f6, color3f3, 0.7f));
        if (bl) {
            string = "images/photo.jpg";
            textureLoader = new TextureLoader(string, "RGB", (Component)((Object)this.canvas));
            if (textureLoader != null && textureLoader.getTexture() != null) {
                appearance.setTexture(textureLoader.getTexture());
            } else {
                System.out.println("No texture loaded from \"" + string + "\"");
            }
        }
        transformGroupArray[0].addChild((Node)new Sphere(f3, 3, 180, appearance));
        branchGroup.addChild((Node)transformGroupArray[1]);
        this.orbitTransform = new Transform3D();
        this.orbitTransform.setTranslation(new Vector3d(0.0, 0.0, (double)this.zoomBar.getValue()));
        this.orbitTranslation = new TransformGroup(this.orbitTransform);
        this.orbitTranslation.setCapability(17);
        this.orbitTranslation.setCapability(18);
        transformGroupArray[1].addChild((Node)this.orbitTranslation);
        this.orbitTranslation.addChild((Node)transformGroupArray[2]);
        string = new Transform3D();
        string.rotX(1.5707963267948966);
        this.rotator[2].setTransformAxis((Transform3D)string);
        transformGroupArray[2].addChild(this.createBody());
        textureLoader = new TransformGroup();
        textureLoader.setCapability(17);
        textureLoader.setCapability(18);
        this.orbitTranslation.addChild((Node)textureLoader);
        MouseRotate mouseRotate = new MouseRotate((TransformGroup)textureLoader);
        mouseRotate.setSchedulingBounds((Bounds)boundingSphere);
        textureLoader.addChild((Node)mouseRotate);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(0.0f, -f / 4.0f, f * 5.0f));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        textureLoader.addChild((Node)transformGroup);
        transformGroup.addChild((Node)viewPlatform);
        MouseZoom mouseZoom = new MouseZoom(transformGroup);
        mouseZoom.setSchedulingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)mouseZoom);
        locale.addBranchGraph(branchGroup);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.zoomBar && this.orbitTranslation != null) {
            this.orbitTransform.setTranslation(new Vector3d(0.0, 0.0, (double)this.zoomBar.getValue()));
            this.orbitTranslation.setTransform(this.orbitTransform);
        } else {
            for (int i = 0; i < this.speedBar.length; ++i) {
                if (adjustmentEvent.getSource() != this.speedBar[i] || this.rotationAlpha[i] == null) continue;
                this.rotationAlpha[i].setIncreasingAlphaDuration((long)this.speedBar[i].getValue());
                break;
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.canvas) {
            Graphics graphics = this.canvas.getGraphics();
            graphics.setColor(Color.white);
            graphics.drawString("Distance: " + this.zoomBar.getValue() + "m", 5, 15);
        } else {
            for (int i = 0; i < this.pause.length; ++i) {
                if (changeEvent.getSource() != this.pause[i]) continue;
                this.rotator[i].setEnable(!this.pause[i].isSelected());
                break;
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            this.zoomBar.setValue(this.zoomBar.getValue() + 10);
        } else if (keyEvent.getKeyCode() == 40) {
            this.zoomBar.setValue(this.zoomBar.getValue() - 10);
        } else if (keyEvent.getKeyCode() == 39) {
            this.zoomBar.setValue(this.zoomBar.getValue() + 1);
        } else if (keyEvent.getKeyCode() == 37) {
            this.zoomBar.setValue(this.zoomBar.getValue() - 1);
        } else if (keyEvent.getKeyCode() == 33) {
            this.zoomBar.setValue(this.zoomBar.getValue() + 1000);
        } else if (keyEvent.getKeyCode() == 34) {
            this.zoomBar.setValue(this.zoomBar.getValue() - 1000);
        } else if (keyEvent.getKeyCode() == 36) {
            this.zoomBar.setValue(this.zoomBar.getMaximum());
        } else if (keyEvent.getKeyCode() == 35) {
            this.zoomBar.setValue(this.zoomBar.getMinimum());
        } else if (keyEvent.getKeyCode() == 83) {
            this.speedBar[0].setValue(this.speedBar[1].getValue());
        } else if (keyEvent.getKeyCode() == 86) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Distance: " + this.zoomBar.getValue() + "\n");
            for (int i = 0; i < this.labelText.length; ++i) {
                stringBuffer.append(this.labelText[i] + ": " + this.speedBar[i].getValue() + "\n");
            }
            JOptionPane.showMessageDialog(null, stringBuffer.toString());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toLowerCase().startsWith("-t")) continue;
            bl = true;
        }
        new MainFrame((Applet)new TranslationTest(bl), 500, 550);
    }

    public Node createBody() {
        int n = 0;
        int n2 = 0;
        SizeVector sizeVector = new SizeVector();
        sizeVector.add(new Size(0.22f, 0.22f));
        sizeVector.add(new Size(0.25f, 0.05f));
        sizeVector.add(new Size(0.18f, 0.62f));
        sizeVector.add(new Size(0.12f, 0.03f));
        sizeVector.add(new Size(0.11f, 0.12f));
        sizeVector.add(new Size(0.08f, 0.04f));
        sizeVector.add(new Size(0.07f, 0.07f));
        sizeVector.add(new Size(0.07f, 0.04f));
        sizeVector.add(new Size(0.04f, 0.29f));
        Color3f color3f = new Color3f(0.49803922f, 0.4745098f, 0.4745098f);
        Color3f color3f2 = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f color3f3 = new Color3f(1.0f, 1.0f, 1.0f);
        Appearance appearance = new Appearance();
        appearance.setMaterial(new Material(color3f2, color3f, color3f3, color3f, 0.7f));
        int n3 = 2;
        float f = 0.0f;
        for (n = n3 + 1; n < sizeVector.size(); ++n) {
            f += sizeVector.getSize((int)n).length;
        }
        sizeVector.getSize((int)n3).length += f;
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(-1.3744467859455345);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.setTranslation(new Vector3f(0.0f, 0.23f, 0.0f));
        TransformGroup transformGroup2 = new TransformGroup(transform3D2);
        transformGroup.addChild((Node)transformGroup2);
        float f2 = 0.0f;
        for (n = 0; n < sizeVector.size(); ++n) {
            TransformGroup transformGroup3;
            if (n != n3) {
                f2 = sizeVector.getSize((int)n).length / 2.0f;
                f2 += sizeVector.getSize((int)n3).length / 2.0f;
                for (n2 = Math.min(n3, n) + 1; n2 <= Math.max(n3, n) - 1; ++n2) {
                    f2 += sizeVector.getSize((int)n2).length;
                }
                f2 = n > n3 ? (f2 -= f) : -f2;
                Transform3D transform3D3 = new Transform3D();
                transform3D3.setTranslation(new Vector3f(0.0f, f2, 0.0f));
                transformGroup3 = new TransformGroup(transform3D3);
                transformGroup3.addChild((Node)new Cylinder(sizeVector.getSize((int)n).radius, sizeVector.getSize((int)n).length, appearance));
            } else {
                transformGroup3 = new TransformGroup();
                transformGroup3.addChild((Node)new Cone(sizeVector.getSize((int)n).radius, sizeVector.getSize((int)n).length, 1, appearance));
            }
            transformGroup2.addChild((Node)transformGroup3);
            f2 = 0.0f;
        }
        return transformGroup;
    }

    class Size {
        float radius = 0.0f;
        float length = 0.0f;

        Size(float f, float f2) {
            this.radius = f;
            this.length = f2;
        }
    }

    class SizeVector
    extends Vector {
        SizeVector() {
        }

        Size getSize(int n) {
            return (Size)this.get(n);
        }
    }
}

