/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.j3d.shape;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;

public class Star
extends Shape3D {
    Color3f activeColor = new Color3f(0.0f, 0.0f, 0.0f);
    Color3f inactiveColor = new Color3f(1.0f, 1.0f, 1.0f);
    int currentIndex = -1;
    Color3f[] colors;
    LineStripArray geometry;
    int numPoints = 0;

    public Star() {
        this(5, 1.0, null);
    }

    public Star(int n, double d) {
        this(n, d, null);
    }

    public Star(Appearance appearance) {
        this(5, 1.0, appearance);
    }

    public Star(int n, double d, Appearance appearance) {
        int[] nArray;
        Point3d[] point3dArray;
        this.numPoints = n;
        this.setAppearance(appearance);
        Point3d[] point3dArray2 = new Point3d[n];
        int n2 = 0;
        double d2 = Math.PI * 2 / (double)n;
        double d3 = 1.5707963267948966 - d2 / 2.0;
        double d4 = d3 - d2 / 2.0;
        Point3d point3d = new Point3d();
        n2 = 0;
        while (n2 < n) {
            point3dArray2[n2] = new Point3d(point3d.x + d * Math.cos(d4), point3d.y + d * Math.sin(d4), point3d.z + 0.0);
            ++n2;
            d4 += d2;
        }
        if (n % 2 != 0) {
            point3dArray = new Point3d[n + 1];
            for (n2 = 0; n2 < point3dArray.length; ++n2) {
                point3dArray[n2] = point3dArray2[n2 * 2 % n];
            }
            nArray = new int[]{point3dArray.length};
        } else {
            point3dArray = new Point3d[n + 2];
            for (n2 = 0; n2 < point3dArray.length / 2; ++n2) {
                point3dArray[n2] = point3dArray2[n2 * 2 % n];
                point3dArray[n2 + point3dArray.length / 2] = point3dArray2[(n2 * 2 + 1) % n];
            }
            nArray = new int[]{point3dArray.length / 2, point3dArray.length / 2};
        }
        this.colors = new Color3f[point3dArray.length];
        for (n2 = 0; n2 < this.colors.length; ++n2) {
            this.colors[n2] = this.inactiveColor;
        }
        this.geometry = new LineStripArray(point3dArray.length, 5, nArray);
        this.geometry.setCapability(3);
        this.geometry.setCoordinates(0, point3dArray);
        this.geometry.setColors(0, this.colors);
        this.setGeometry((Geometry)this.geometry);
    }

    public int getNumIndices() {
        return this.colors.length;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public int getIndex() {
        return this.currentIndex;
    }

    public void setIndex(int n) {
        int n2 = 0;
        int n3 = 0;
        if (n > this.currentIndex) {
            n3 = Math.min(n, this.colors.length - 1);
            for (n2 = this.currentIndex + 1; n2 <= n3; ++n2) {
                this.colors[n2] = this.activeColor;
            }
        } else {
            n3 = Math.max(-1, n);
            for (n2 = this.currentIndex; n2 > n3; --n2) {
                this.colors[n2] = this.inactiveColor;
            }
        }
        this.geometry.setColors(0, this.colors);
        this.currentIndex = n3;
    }
}

