/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class ComponentViewer
extends JApplet
implements ActionListener {
    public static final String EXIT_COMMAND = "exit";
    public static final String LOAD_COMMAND = "load";
    public static final String COMPONENT_PROPERTY = "components";
    GridBagLayout layout = new GridBagLayout();
    GridBagConstraints gridbag = new GridBagConstraints();
    JMenuItem loadItem = new JMenuItem("Load", 76);
    JMenuItem exitItem = new JMenuItem("Exit", 88);
    EventListenerList listeners = new EventListenerList();

    public ComponentViewer() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Options");
        jMenu.setMnemonic(79);
        jMenu.getAccessibleContext().setAccessibleDescription("Options");
        jMenuBar.add(jMenu);
        this.loadItem.setActionCommand(LOAD_COMMAND);
        this.loadItem.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        this.loadItem.getAccessibleContext().setAccessibleDescription("Load");
        this.loadItem.addActionListener(this);
        jMenu.add(this.loadItem);
        this.exitItem.setActionCommand(EXIT_COMMAND);
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.exitItem.getAccessibleContext().setAccessibleDescription("Exit");
        this.exitItem.addActionListener(this);
        jMenu.add(this.exitItem);
        this.getContentPane().setLayout(this.layout);
        this.gridbag.gridwidth = 0;
        this.gridbag.fill = 1;
        this.gridbag.weightx = 0.5;
        this.gridbag.weighty = 0.5;
    }

    public ComponentViewer(String[] stringArray) {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Options");
        jMenu.setMnemonic(79);
        jMenu.getAccessibleContext().setAccessibleDescription("Options");
        jMenuBar.add(jMenu);
        this.loadItem.setActionCommand(LOAD_COMMAND);
        this.loadItem.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        this.loadItem.getAccessibleContext().setAccessibleDescription("Load");
        this.loadItem.addActionListener(this);
        jMenu.add(this.loadItem);
        this.exitItem.setActionCommand(EXIT_COMMAND);
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.exitItem.getAccessibleContext().setAccessibleDescription("Exit");
        this.exitItem.addActionListener(this);
        jMenu.add(this.exitItem);
        this.getContentPane().setLayout(this.layout);
        this.gridbag.gridwidth = 0;
        this.gridbag.fill = 1;
        this.gridbag.weightx = 0.5;
        this.gridbag.weighty = 0.5;
        this.loadComponents(stringArray);
    }

    public void start() {
        this.exitItem.setEnabled(false);
    }

    public void init() {
        int n = 0;
        while (this.getParameter("component_" + (n + 1)) != null) {
            ++n;
        }
        String[] stringArray = new String[n];
        for (int i = 1; i <= n; ++i) {
            stringArray[i - 1] = this.getParameter("component_" + i);
        }
        this.loadComponents(stringArray);
    }

    public void loadComponents(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.loadComponent(stringArray[i]);
        }
    }

    public void loadComponent(String string) {
        try {
            Component component = (Component)Class.forName(string).newInstance();
            this.layout.setConstraints(component, this.gridbag);
            this.getContentPane().add(component);
            this.firePropertyChange(new PropertyChangeEvent(this, COMPONENT_PROPERTY, null, null));
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(this, "No class found for \"" + string + "\"", "Loading Error", 0);
        }
        catch (ClassCastException classCastException) {
            JOptionPane.showMessageDialog(this, "\"" + string + "\" could not be cast as a Component", "Loading Error", 0);
        }
        catch (InstantiationException instantiationException) {
            JOptionPane.showMessageDialog(this, "Error: " + instantiationException, "Instantiation Error", 0);
            instantiationException.printStackTrace(System.err);
        }
        catch (IllegalAccessException illegalAccessException) {
            JOptionPane.showMessageDialog(this, "Error: " + illegalAccessException, "Illegal Access Error", 0);
            illegalAccessException.printStackTrace(System.err);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == EXIT_COMMAND) {
            System.exit(0);
        } else if (string == LOAD_COMMAND) {
            String string2 = JOptionPane.showInputDialog(this, (Object)"Which component would you like to load?");
            if (string2 != null) {
                this.loadComponent(string2);
            }
        } else {
            JOptionPane.showInternalMessageDialog(this, "Unknown action command: " + string);
        }
    }

    public boolean isPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object[] objectArray = this.listeners.getListenerList();
        boolean bl = false;
        for (int i = objectArray.length - 2; i >= 0 && !bl; i -= 2) {
            bl = propertyChangeListener == objectArray[i + 1];
        }
        return bl;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(PropertyChangeListener.class, propertyChangeListener);
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0 && propertyChangeEvent != null; i -= 2) {
            if (objectArray[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }

    public static void main(String[] stringArray) {
        final JFrame jFrame = new JFrame("Component Tester");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ComponentViewer componentViewer = new ComponentViewer(stringArray);
        componentViewer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == ComponentViewer.COMPONENT_PROPERTY) {
                    jFrame.pack();
                }
            }
        });
        jFrame.setContentPane(componentViewer.getContentPane());
        jFrame.setJMenuBar(componentViewer.getJMenuBar());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

