/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.testbed;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import javax.media.j3d.Alpha;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class TestBed
extends Applet {
    protected Canvas3D canvas;
    protected SimpleUniverse universe;
    protected float cubeSize = 1.0f;

    public void addNodes(BranchGroup branchGroup, TransformGroup transformGroup) {
    }

    public BranchGroup createSceneGraph(Canvas3D canvas3D, ViewingPlatform viewingPlatform) {
        BranchGroup branchGroup = new BranchGroup();
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f color3f = new Color3f(0.15f, 0.15f, 0.6f);
        Background background = new Background(color3f);
        background.setApplicationBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)background);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d(0.0, 0.0, (double)(-this.cubeSize * 5.0f)));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        Transform3D transform3D2 = new Transform3D();
        Alpha alpha = new Alpha(-1, 4000L);
        TransformGroup transformGroup2 = new TransformGroup();
        transformGroup2.setCapability(18);
        RotationInterpolator rotationInterpolator = new RotationInterpolator(alpha, transformGroup2, transform3D2, 0.0f, (float)Math.PI * 2);
        rotationInterpolator.setSchedulingBounds((Bounds)boundingSphere);
        transformGroup2.addChild((Node)rotationInterpolator);
        branchGroup.addChild((Node)transformGroup2);
        transformGroup2.addChild((Node)new ColorCube((double)this.cubeSize));
        this.addNodes(branchGroup, viewingPlatform.getViewPlatformTransform());
        branchGroup.compile();
        return branchGroup;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
        this.canvas = new Canvas3D(graphicsConfiguration);
        this.add("Center", (Component)this.canvas);
        this.validate();
        this.canvas.requestFocus();
        SimpleUniverse simpleUniverse = new SimpleUniverse(this.canvas);
        simpleUniverse.getViewingPlatform().setNominalViewingTransform();
        ViewingPlatform viewingPlatform = simpleUniverse.getViewingPlatform();
        BranchGroup branchGroup = this.createSceneGraph(this.canvas, viewingPlatform);
        simpleUniverse.addBranchGraph(branchGroup);
        OrbitBehavior orbitBehavior = new OrbitBehavior(this.canvas, 4096);
        orbitBehavior.setMinRadius(20.0);
        orbitBehavior.setSchedulingBounds((Bounds)new BoundingSphere());
        simpleUniverse.getViewingPlatform().setViewPlatformBehavior((ViewPlatformBehavior)orbitBehavior);
        Transform3D transform3D = new Transform3D();
        transform3D.lookAt(new Point3d(20.0, 0.0, 20.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0));
        transform3D.invert();
        viewingPlatform.getViewPlatformTransform().setTransform(transform3D);
    }

    public void destroy() {
        this.universe.removeAllLocales();
    }

    public static void main(String[] stringArray) throws Exception {
        new MainFrame((Applet)new TestBed(), 600, 600);
    }
}

