/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.testbed;

import com.sun.j3d.utils.applet.MainFrame;
import com.xith.java3d.overlay.ChatManager;
import com.xith.java3d.overlay.ImageButtonOverlay;
import com.xith.java3d.overlay.LabelOverlay;
import com.xith.java3d.overlay.Overlay;
import com.xith.java3d.overlay.OverlayScroller;
import com.xith.java3d.overlay.OverlayUtilities;
import com.xith.java3d.testbed.TestBed;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedTime;

public class OverlayTester
extends TestBed {
    public void addNodes(BranchGroup branchGroup, TransformGroup transformGroup) {
        Font font = new Font("Helvetica", 1, 12);
        Color color = Color.red;
        LabelOverlay labelOverlay = new LabelOverlay(this.canvas, new Rectangle(10, 10, 100, 20), "FPS"){

            public void initialize() {
                super.initialize();
                Behavior behavior = new Behavior(){
                    long lastTime = 0L;
                    long lastFrameCount = 0L;
                    View view = this.getCanvas().getView();
                    WakeupCriterion wakeup = new WakeupOnElapsedTime(1000L);

                    public void initialize() {
                        this.wakeupOn((WakeupCondition)this.wakeup);
                        this.lastTime = System.currentTimeMillis();
                    }

                    public void processStimulus(Enumeration enumeration) {
                        long l = System.currentTimeMillis();
                        long l2 = this.view.getFrameNumber();
                        this.setText("Frames: " + (l2 - this.lastFrameCount) * 1000L / (l - this.lastTime));
                        this.lastTime = l;
                        this.lastFrameCount = l2;
                        this.wakeupOn((WakeupCondition)this.wakeup);
                    }
                };
                behavior.setSchedulingBounds((Bounds)new BoundingSphere());
                this.getRoot().addChild((Node)behavior);
            }
        };
        transformGroup.addChild((Node)labelOverlay.getRoot());
        Overlay[] overlayArray = new LabelOverlay[5];
        for (int i = overlayArray.length - 1; i >= 0; --i) {
            overlayArray[i] = new LabelOverlay(this.canvas, new Rectangle(0, 0, 500, 16), "", font, color);
        }
        final OverlayScroller overlayScroller = new OverlayScroller(this.canvas, new Dimension(10, 20), overlayArray, new Insets(5, 25, 5, 25));
        overlayScroller.setRelativePosition(1, 1);
        transformGroup.addChild((Node)overlayScroller.getRoot());
        ChatManager chatManager = new ChatManager(overlayScroller);
        this.canvas.addKeyListener((KeyListener)chatManager);
        this.canvas.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 112: {
                        Color color = new Color((float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random());
                        int n = 0;
                        overlayScroller.setUpdating(false);
                        for (n = overlayScroller.getNumLines() - 1; n >= 0; --n) {
                            ((LabelOverlay)overlayScroller.getLine(n)).setBackgroundColor(color);
                        }
                        for (n = 3; n >= 0; --n) {
                            overlayScroller.getBorder(n).setBackgroundColor(color);
                        }
                        overlayScroller.setUpdating(true);
                        break;
                    }
                    case 113: {
                        ((LabelOverlay)overlayScroller.getLine(0)).setText("I'm afraid I can't let you do that Will.", 1);
                        ((LabelOverlay)overlayScroller.getLine(0)).waitForTyping();
                    }
                }
            }
        });
        URL[] uRLArray = new URL[4];
        uRLArray[0] = this.getClass().getResource("/images/overlay/mankin_inactive.gif");
        uRLArray[1] = this.getClass().getResource("/images/overlay/mankin_active.gif");
        uRLArray[3] = this.getClass().getResource("/images/overlay/mankin_mouseover.gif");
        uRLArray[2] = this.getClass().getResource("/images/overlay/mankin_clicked.gif");
        Dimension dimension = new Dimension();
        boolean bl = true;
        BufferedImage[] bufferedImageArray = OverlayUtilities.loadImages(uRLArray, (Component)this.canvas, bl, dimension);
        ImageButtonOverlay imageButtonOverlay = new ImageButtonOverlay(this.canvas, new Rectangle(new Point(10, 20), dimension), bl, false, bufferedImageArray);
        imageButtonOverlay.setRelativePosition(0, 1);
        transformGroup.addChild((Node)imageButtonOverlay.getRoot());
    }

    public static void main(String[] stringArray) throws Exception {
        new MainFrame((Applet)new OverlayTester(), 600, 600);
    }
}

