/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.overlay;

import com.xith.java3d.overlay.OverlayBase;
import com.xith.java3d.overlay.OverlayUtilities;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Material;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;

class SubOverlay {
    public static final int NEXT_BUFFER = -1;
    BufferedImage[] buffer;
    ImageComponent2D[] bufferHolder;
    int numBuffers;
    int activeBufferIndex = 0;
    Texture2D texture;
    Shape3D shape;
    OverlayBase overlay;
    Rectangle space;
    int[] transferBuffer;

    protected SubOverlay(OverlayBase overlayBase, Rectangle rectangle) {
        this(overlayBase, rectangle, 2);
    }

    protected SubOverlay(OverlayBase overlayBase, Rectangle rectangle, int n) {
        this.overlay = overlayBase;
        this.space = rectangle;
        this.numBuffers = n;
        this.buffer = new BufferedImage[n];
        this.bufferHolder = new ImageComponent2D[n];
        this.transferBuffer = new int[rectangle.width];
        boolean bl = overlayBase.hasAlphaComponent();
        int n2 = bl ? 2 : 1;
        Dimension dimension = new Dimension(OverlayUtilities.smallestPower(rectangle.width), OverlayUtilities.smallestPower(rectangle.height));
        for (int i = n - 1; i >= 0; --i) {
            this.buffer[i] = OverlayUtilities.createBufferedImage(dimension, bl);
            this.bufferHolder[i] = new ImageComponent2D(n2, this.buffer[i], true, true);
        }
        Appearance appearance = new Appearance();
        appearance.setPolygonAttributes(overlayBase.getPolygonAttributes());
        appearance.setRenderingAttributes(overlayBase.getRenderingAttributes());
        appearance.setTextureAttributes(overlayBase.getTextureAttributes());
        appearance.setTransparencyAttributes(overlayBase.getTransparencyAttributes());
        Material material = new Material();
        material.setLightingEnable(false);
        appearance.setMaterial(material);
        this.texture = new Texture2D(1, bl ? 6 : 5, dimension.width, dimension.height);
        this.texture.setBoundaryModeS(2);
        this.texture.setBoundaryModeT(2);
        this.texture.setMagFilter(0);
        this.texture.setMinFilter(0);
        this.texture.setImage(0, (ImageComponent)this.bufferHolder[this.activeBufferIndex]);
        this.texture.setCapability(7);
        appearance.setTexture((Texture)this.texture);
        this.shape = SubOverlay.buildShape(appearance, rectangle);
    }

    public static int smallestPower(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 *= 2) {
        }
        return n2;
    }

    public static Shape3D buildShape(Appearance appearance, Rectangle rectangle) {
        Object object;
        Texture texture = appearance.getTexture();
        QuadArray quadArray = new QuadArray(4, texture == null ? 1 : 33);
        float[] fArray = new float[]{rectangle.x + rectangle.width, rectangle.y, 0.0f, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0.0f, rectangle.x, rectangle.y + rectangle.height, 0.0f, rectangle.x, rectangle.y, 0.0f};
        quadArray.setCoordinates(0, fArray);
        if (texture != null) {
            object = new Point2D.Float((float)(rectangle.getWidth() / (double)texture.getWidth()), (float)(rectangle.getHeight() / (double)texture.getHeight()));
            float[] fArray2 = new float[]{object.x, 0.0f, object.x, object.y, 0.0f, object.y, 0.0f, 0.0f};
            quadArray.setTextureCoordinates(0, 0, fArray2);
        }
        object = new Shape3D();
        object.setGeometry((Geometry)quadArray);
        object.setAppearance(appearance);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBuffer(BufferedImage bufferedImage, int n) {
        Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        if (n == -1) {
            n = this.getNextBufferIndex();
        }
        BufferedImage bufferedImage2 = this.buffer[n];
        synchronized (bufferedImage2) {
            for (int i = 0; i < this.space.height; ++i) {
                bufferedImage.getRGB(this.space.x, dimension.height - this.space.y - this.space.height + i, this.transferBuffer.length, 1, this.transferBuffer, 0, dimension.width);
                this.buffer[n].setRGB(0, this.space.height - i - 1, this.transferBuffer.length, 1, this.transferBuffer, 0, dimension.width);
            }
        }
    }

    public int getNextBufferIndex() {
        return (this.activeBufferIndex + 1) % this.numBuffers;
    }

    public void setActiveBufferIndex(int n) {
        if (n == -1) {
            n = this.getNextBufferIndex();
        }
        if (this.activeBufferIndex != n) {
            this.activeBufferIndex = n;
            this.texture.setImage(0, (ImageComponent)this.bufferHolder[n]);
        }
    }

    public Shape3D getShape() {
        return this.shape;
    }
}

