/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.overlay;

import com.xith.java3d.overlay.OverlayBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.net.URL;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;

public class OverlayUtilities {
    public static BufferedImage createBufferedImage(Dimension dimension, boolean bl) {
        int n = bl ? 4 : 3;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 8;
            nArray2[i] = i;
        }
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int n2 = bl ? 3 : 1;
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, bl, false, n2, 0);
        WritableRaster writableRaster = Raster.createInterleavedRaster(0, dimension.width, dimension.height, dimension.width * n, n, nArray2, null);
        return new BufferedImage(componentColorModel, writableRaster, false, null);
    }

    public static BufferedImage[] loadImages(URL[] uRLArray, Component component, boolean bl) {
        return OverlayUtilities.loadImages(uRLArray, component, bl, new Dimension());
    }

    public static BufferedImage[] loadImages(URL[] uRLArray, Component component, boolean bl, Dimension dimension) {
        BufferedImage[] bufferedImageArray = new BufferedImage[uRLArray.length];
        MediaTracker mediaTracker = new MediaTracker(component);
        int n = 0;
        int n2 = 5000;
        for (int i = uRLArray.length - 1; i >= 0; --i) {
            if (uRLArray[i] == null) continue;
            Image image = Toolkit.getDefaultToolkit().getImage(uRLArray[i]);
            mediaTracker.addImage(image, n);
            try {
                mediaTracker.waitForID(n, n2);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Error: " + uRLArray[i] + " interrupted while loading");
            }
            mediaTracker.removeImage(image, n);
            Dimension dimension2 = new Dimension(image.getWidth(component), image.getHeight(component));
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = Math.max(dimension.height, dimension2.height);
            bufferedImageArray[i] = OverlayUtilities.createBufferedImage(dimension2, bl);
            ((Graphics2D)bufferedImageArray[i].getGraphics()).drawImage(image, null, component);
        }
        return bufferedImageArray;
    }

    public static void setBackgroundColor(OverlayBase[] overlayBaseArray, Color color) {
        int n = 0;
        for (n = overlayBaseArray.length - 1; n >= 0; --n) {
            overlayBaseArray[n].getUpdateManager().setUpdating(false);
            overlayBaseArray[n].setBackgroundColor(color);
        }
        for (n = overlayBaseArray.length - 1; n >= 0; --n) {
            overlayBaseArray[n].getUpdateManager().setUpdating(true);
        }
    }

    public static Vector subdivide(Dimension dimension, int n, int n2) {
        Vector vector = OverlayUtilities.components(dimension.width, n, n2);
        Vector vector2 = OverlayUtilities.components(dimension.height, n, n2);
        Vector<Rectangle> vector3 = new Vector<Rectangle>();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < vector2.size(); ++n3) {
            n5 = 0;
            for (n4 = 0; n4 < vector.size(); ++n4) {
                vector3.add(new Rectangle(n5, n6, (Integer)vector.get(n4), (Integer)vector2.get(n3)));
                n5 += ((Integer)vector.get(n4)).intValue();
            }
            n6 += ((Integer)vector2.get(n3)).intValue();
        }
        return vector3;
    }

    public static Vector components(int n, int n2, int n3) {
        Vector<Integer> vector = new Vector<Integer>();
        while (n > 0) {
            int n4 = Math.min(OverlayUtilities.optimalPower(n, n2, n3), n);
            vector.add(new Integer(n4));
            n -= n4;
        }
        return vector;
    }

    public static int optimalPower(int n, int n2, int n3) {
        int n4 = 1;
        n = Math.min(n, n3);
        while (n4 * 2 - n <= n2) {
            n4 *= 2;
        }
        return n4;
    }

    public static int smallestPower(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 *= 2) {
        }
        return n2;
    }

    public static Shape3D buildShape(Appearance appearance, Rectangle rectangle) {
        Object object;
        Texture texture = appearance.getTexture();
        QuadArray quadArray = new QuadArray(4, texture == null ? 1 : 33);
        float[] fArray = new float[]{rectangle.x + rectangle.width, rectangle.y, 0.0f, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0.0f, rectangle.x, rectangle.y + rectangle.height, 0.0f, rectangle.x, rectangle.y, 0.0f};
        quadArray.setCoordinates(0, fArray);
        if (texture != null) {
            object = new Point2D.Float((float)(rectangle.getWidth() / (double)texture.getWidth()), (float)(rectangle.getHeight() / (double)texture.getHeight()));
            float[] fArray2 = new float[]{object.x, 0.0f, object.x, object.y, 0.0f, object.y, 0.0f, 0.0f};
            quadArray.setTextureCoordinates(0, 0, fArray2);
        }
        object = new Shape3D();
        object.setGeometry((Geometry)quadArray);
        object.setAppearance(appearance);
        return object;
    }

    public static void repositonBounds(Rectangle rectangle, int[] nArray, Dimension dimension, Dimension dimension2) {
        switch (nArray[0]) {
            case 0: {
                rectangle.x = dimension.width - rectangle.width - dimension2.width;
                break;
            }
            case 1: {
                rectangle.x = dimension2.width;
                break;
            }
            case 3: {
                rectangle.x = dimension.width / 2 - rectangle.width / 2 - dimension2.width;
            }
        }
        switch (nArray[1]) {
            case 0: {
                rectangle.y = dimension2.height;
                break;
            }
            case 1: {
                rectangle.y = dimension.height - rectangle.height - dimension2.height;
                break;
            }
            case 3: {
                rectangle.y = dimension.height / 2 - rectangle.height / 2 - dimension2.height;
            }
        }
    }
}

