/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.overlay;

import com.xith.java3d.overlay.Overlay;
import com.xith.java3d.overlay.OverlayBase;
import com.xith.java3d.overlay.OverlayUtilities;
import com.xith.java3d.overlay.ScrollEvent;
import com.xith.java3d.overlay.ScrollEventListener;
import com.xith.java3d.overlay.UpdateControlBehavior;
import com.xith.java3d.overlay.UpdateManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.swing.event.EventListenerList;

public class OverlayScroller
implements Overlay,
UpdateManager {
    public static final int BORDER_LEFT = 0;
    public static final int BORDER_RIGHT = 1;
    public static final int BORDER_TOP = 2;
    public static final int BORDER_BOTTOM = 3;
    private Rectangle bounds;
    private Insets margin;
    private int[] relativePosition = new int[]{1, 0};
    private Dimension offset;
    private boolean visible = true;
    private Color borderBackgroundColor;
    private BufferedImage borderBackgroundImage;
    private int backgroundMode;
    private boolean antialiased = true;
    private Canvas3D canvas3D;
    private OverlayBase[] border;
    private Overlay[] line;
    private static final int VISIBLE = Integer.parseInt("1", 2);
    private static final int ORDER = Integer.parseInt("10", 2);
    private static final int LINE_POSITION = Integer.parseInt("100", 2);
    private static final int BORDER_POSITION = Integer.parseInt("1000", 2);
    private static final int BORDER_BACKGROUND_IMAGE = Integer.parseInt("10000", 2);
    private static final int BORDER_BACKGROUND_COLOR = Integer.parseInt("100000", 2);
    private static final int BACKGROUND_MODE = Integer.parseInt("1000000", 2);
    private static final int ANTIALIASED = Integer.parseInt("10000000", 2);
    private static final int ITEM = Integer.parseInt("100000000", 2);
    private int dirtyCheck = 0;
    UpdateManager updateManager;
    private EventListenerList listeners = new EventListenerList();
    private BranchGroup consoleBranchGroup;

    public OverlayScroller(Canvas3D canvas3D, Overlay[] overlayArray, Insets insets) {
        this(canvas3D, new Dimension(), null, overlayArray, insets);
    }

    public OverlayScroller(Canvas3D canvas3D, Dimension dimension, Overlay[] overlayArray, Insets insets) {
        this(canvas3D, dimension, null, overlayArray, insets);
    }

    public OverlayScroller(Canvas3D canvas3D, UpdateManager updateManager, Overlay[] overlayArray, Insets insets) {
        this(canvas3D, true, false, new Dimension(), updateManager, overlayArray, insets);
    }

    public OverlayScroller(Canvas3D canvas3D, Dimension dimension, UpdateManager updateManager, Overlay[] overlayArray, Insets insets) {
        this(canvas3D, true, false, dimension, updateManager, overlayArray, insets);
    }

    public OverlayScroller(Canvas3D canvas3D, boolean bl, boolean bl2, Dimension dimension, UpdateManager updateManager, Overlay[] overlayArray, Insets insets) {
        int n;
        this.canvas3D = canvas3D;
        this.margin = insets;
        this.line = overlayArray;
        this.offset = dimension;
        canvas3D.addComponentListener((ComponentListener)new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                OverlayScroller.this.dirty(LINE_POSITION | BORDER_POSITION);
            }
        });
        Dimension dimension2 = new Dimension();
        for (int i = 0; i < overlayArray.length; ++i) {
            dimension2.width = Math.max(dimension2.width, overlayArray[i].getBounds().width);
            dimension2.height += overlayArray[i].getBounds().height;
        }
        this.bounds = new Rectangle(dimension.width, dimension.height, insets.left + dimension2.width + insets.right, insets.top + dimension2.height + insets.bottom);
        Rectangle rectangle = null;
        this.border = new OverlayBase[4];
        for (n = 0; n < this.border.length; ++n) {
            switch (n) {
                case 0: {
                    rectangle = new Rectangle(0, 0, insets.left, dimension2.height);
                    break;
                }
                case 1: {
                    rectangle = new Rectangle(0, 0, insets.right, dimension2.height);
                    break;
                }
                case 2: {
                    rectangle = new Rectangle(0, 0, this.bounds.width, insets.top);
                    break;
                }
                case 3: {
                    rectangle = new Rectangle(0, 0, this.bounds.width, insets.bottom);
                }
            }
            this.border[n] = new OverlayBase(canvas3D, rectangle, bl, bl2);
        }
        this.consoleBranchGroup = new BranchGroup();
        if (this.updateManager == null) {
            UpdateControlBehavior updateControlBehavior = new UpdateControlBehavior(this);
            updateControlBehavior.setSchedulingBounds((Bounds)new BoundingSphere());
            this.consoleBranchGroup.addChild((Node)updateControlBehavior);
            this.updateManager = updateControlBehavior;
        }
        for (n = overlayArray.length - 1; n >= 0; --n) {
            this.consoleBranchGroup.addChild((Node)overlayArray[n].getRoot());
            overlayArray[n].setUpdateManager(this);
        }
        for (n = this.border.length - 1; n >= 0; --n) {
            this.consoleBranchGroup.addChild((Node)this.border[n].getRoot());
            this.border[n].setUpdateManager(this);
        }
        this.initialize();
        this.dirtyCheck = Integer.parseInt("111111111111111111", 2);
    }

    public void initialize() {
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Canvas3D getCanvas() {
        return this.canvas3D;
    }

    public BranchGroup getRoot() {
        return this.consoleBranchGroup;
    }

    public OverlayBase getBorder(int n) {
        return this.border[n];
    }

    public void setAntialiased(boolean bl) {
        if (this.antialiased != bl) {
            this.antialiased = bl;
            this.dirty(ANTIALIASED);
        }
    }

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public void setUpdateManager(UpdateManager updateManager) {
        if (this.updateManager != updateManager) {
            this.updateManager = updateManager;
            updateManager.updateRequested();
        }
    }

    public boolean isUpdating() {
        return this.updateManager.isUpdating();
    }

    public void setUpdating(boolean bl) {
        this.updateManager.setUpdating(bl);
    }

    public int getNumLines() {
        return this.line.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Overlay getLine(int n) {
        Overlay[] overlayArray = this.line;
        synchronized (this.line) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.line[n];
        }
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.dirty(VISIBLE);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void scroll(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n2 > 0) {
            Overlay[] overlayArray = new Overlay[n2];
            int n5 = this.line.length - 1;
            for (n3 = 0; n3 < n2; ++n3) {
                overlayArray[n3] = this.line[n5 - n3];
            }
            Overlay[] overlayArray2 = this.line;
            synchronized (this.line) {
                n3 = n5;
                for (n4 = n5 - n2; n4 >= n; --n4) {
                    this.line[n3] = this.line[n4];
                    --n3;
                }
                n4 = 0;
                while (n3 >= n) {
                    this.line[n3] = overlayArray[n4];
                    this.fireItemScrolled(new ScrollEvent(this, this.line[n3], 0));
                    --n3;
                    ++n4;
                }
                this.dirty(LINE_POSITION);
                // ** MonitorExit[var7_9] (shouldn't be in output)
                return;
            }
        }
        if (n2 >= 0) return;
        Overlay[] overlayArray = new Overlay[n2 *= -1];
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            overlayArray[n3] = this.line[n3];
        }
        Overlay[] overlayArray3 = this.line;
        synchronized (this.line) {
            n3 = 0;
            for (n4 = n2; n4 <= n; ++n4) {
                this.line[n3] = this.line[n4];
                ++n3;
            }
            n4 = 0;
            while (n3 <= n) {
                this.line[n3] = overlayArray[n4];
                this.fireItemScrolled(new ScrollEvent(this, this.line[n3], 1));
                ++n3;
                ++n4;
            }
            this.dirty(LINE_POSITION);
            // ** MonitorExit[var6_8] (shouldn't be in output)
            return;
        }
    }

    public void setRelativePosition(int[] nArray) {
        this.setRelativePosition(this.relativePosition[0], this.relativePosition[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRelativePosition(int n, int n2) {
        if (this.relativePosition[0] == n && this.relativePosition[1] == n2) return;
        int[] nArray = this.relativePosition;
        synchronized (this.relativePosition) {
            this.relativePosition[0] = n;
            this.relativePosition[1] = n2;
            this.dirty(LINE_POSITION | BORDER_POSITION);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void setOffset(Dimension dimension) {
        this.setOffset(dimension.width, dimension.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffset(int n, int n2) {
        if (this.offset.height != n || this.offset.height != n2) {
            Rectangle rectangle = this.bounds;
            synchronized (rectangle) {
                this.offset.width = n;
                this.offset.height = n2;
                this.dirty(BORDER_POSITION | LINE_POSITION);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncBorderPositions() {
        Dimension dimension = this.offset;
        synchronized (dimension) {
            OverlayUtilities.repositonBounds(this.bounds, this.relativePosition, this.canvas3D.getSize(), this.offset);
            Dimension dimension2 = new Dimension();
            for (int i = 0; i < this.border.length; ++i) {
                switch (i) {
                    case 2: {
                        dimension2.width = this.bounds.x;
                        dimension2.height = this.bounds.y;
                        break;
                    }
                    case 3: {
                        dimension2.width = this.bounds.x;
                        dimension2.height = this.bounds.y + this.bounds.height - this.margin.bottom;
                        break;
                    }
                    case 0: {
                        dimension2.width = this.bounds.x;
                        dimension2.height = this.bounds.y + this.margin.top;
                        break;
                    }
                    case 1: {
                        dimension2.width = this.bounds.x + this.bounds.width - this.margin.left;
                        dimension2.height = this.bounds.y + this.margin.top;
                    }
                }
                this.border[i].setOffset(dimension2);
            }
            this.clean(BORDER_POSITION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncLinePositions() {
        Overlay[] overlayArray = this.line;
        synchronized (this.line) {
            OverlayUtilities.repositonBounds(this.bounds, this.relativePosition, this.canvas3D.getSize(), this.offset);
            Dimension dimension = new Dimension(this.bounds.x + this.margin.left, this.bounds.y + this.bounds.height - this.margin.top);
            for (int i = 0; i < this.line.length; ++i) {
                dimension.height -= this.line[i].getBounds().height;
                this.line[i].setOffset(dimension);
            }
            this.clean(LINE_POSITION);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void syncVisible() {
        int n;
        for (n = this.border.length - 1; n >= 0; --n) {
            this.border[n].setVisible(this.visible);
        }
        for (n = this.line.length - 1; n >= 0; --n) {
            this.line[n].setVisible(this.visible);
        }
        this.clean(VISIBLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncBorderBackgroundColor() {
        if (this.borderBackgroundColor != null) {
            Color color = this.borderBackgroundColor;
            synchronized (color) {
                for (int i = this.border.length - 1; i >= 0; --i) {
                    this.border[i].setBackgroundColor(this.borderBackgroundColor);
                }
                this.clean(BORDER_BACKGROUND_COLOR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncBorderBackgroundImage() {
        if (this.borderBackgroundImage != null) {
            BufferedImage bufferedImage = this.borderBackgroundImage;
            synchronized (bufferedImage) {
                for (int i = this.border.length - 1; i >= 0; --i) {
                    this.border[i].setBackgroundImage(this.borderBackgroundImage);
                }
                this.clean(BORDER_BACKGROUND_IMAGE);
            }
        }
    }

    public void dirty(int n) {
        this.dirtyCheck |= n;
        if (this.updateManager != null) {
            this.updateManager.updateRequested();
        } else {
            System.err.println("Null update manager in " + this);
        }
    }

    public void clean(int n) {
        this.dirtyCheck &= ~n;
    }

    public void updateRequested() {
        this.dirty(ITEM);
    }

    public void update() {
        if ((this.dirtyCheck & BORDER_POSITION) != 0) {
            this.syncBorderPositions();
        }
        if ((this.dirtyCheck & LINE_POSITION) != 0) {
            this.syncLinePositions();
        }
        if ((this.dirtyCheck & VISIBLE) != 0) {
            this.syncVisible();
        }
        if ((this.dirtyCheck & BORDER_BACKGROUND_COLOR) != 0) {
            this.syncBorderBackgroundColor();
        }
        if ((this.dirtyCheck & BORDER_BACKGROUND_IMAGE) != 0) {
            this.syncBorderBackgroundImage();
        }
        if ((this.dirtyCheck & ITEM) != 0) {
            int n;
            for (n = this.line.length - 1; n >= 0; --n) {
                this.line[n].update();
            }
            for (n = this.border.length - 1; n >= 0; --n) {
                this.border[n].update();
            }
            this.clean(ITEM);
        }
    }

    public void addScrollEventListener(ScrollEventListener scrollEventListener) {
        this.listeners.add(ScrollEventListener.class, scrollEventListener);
    }

    public void removeScrollEventListener(ScrollEventListener scrollEventListener) {
        this.listeners.remove(ScrollEventListener.class, scrollEventListener);
    }

    public void fireItemScrolled(ScrollEvent scrollEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ScrollEventListener.class) continue;
            ((ScrollEventListener)objectArray[i + 1]).itemScrolled(scrollEvent);
        }
    }
}

