/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.overlay;

import com.xith.java3d.overlay.ComponentMouseManager;
import com.xith.java3d.overlay.Overlay;
import com.xith.java3d.overlay.OverlayUtilities;
import com.xith.java3d.overlay.ScreenComponent;
import com.xith.java3d.overlay.SubOverlay;
import com.xith.java3d.overlay.UpdateControlBehavior;
import com.xith.java3d.overlay.UpdateManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color4f;
import javax.vecmath.Vector3d;

public class OverlayBase
implements Overlay,
ScreenComponent {
    private static final double consoleZ = (double)2.1f;
    protected int backgroundMode = 1;
    protected int[] relativePosition = new int[]{1, 0};
    private BufferedImage backgroundImage;
    private boolean hasAlpha;
    private boolean visible;
    private boolean antialiased;
    private Rectangle bounds;
    private Dimension offset;
    private UpdateManager updateManager;
    private Canvas3D canvas3D;
    protected BufferedImage canvas;
    protected SubOverlay[] subOverlay = new SubOverlay[0];
    protected int activeBuffer = -1;
    protected BranchGroup consoleBranchGroup;
    protected TransformGroup consoleTransformGroup;
    private RenderingAttributes renderAttributes;
    private PolygonAttributes polygonAttributes;
    private TextureAttributes textureAttributes;
    private TransparencyAttributes transparencyAttributes;
    public static final int VISIBLE = 0;
    public static final int POSITION = 1;
    public static final int ACTIVE_BUFFER = 2;
    private boolean[] dirtyCheck = new boolean[3];
    ComponentMouseManager mouseManager;
    private boolean painting = false;

    public OverlayBase(Canvas3D canvas3D, Rectangle rectangle) {
        this(canvas3D, rectangle, true, false, null);
    }

    public OverlayBase(Canvas3D canvas3D, Rectangle rectangle, UpdateManager updateManager) {
        this(canvas3D, rectangle, true, false, updateManager);
    }

    public OverlayBase(Canvas3D canvas3D, Rectangle rectangle, boolean bl, boolean bl2) {
        this(canvas3D, rectangle, bl, bl2, null);
    }

    public OverlayBase(Canvas3D canvas3D, Rectangle rectangle, boolean bl, boolean bl2, UpdateManager updateManager) {
        this(canvas3D, rectangle, bl, bl2, updateManager, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OverlayBase(Canvas3D canvas3D, Rectangle rectangle, boolean bl, boolean bl2, UpdateManager updateManager, int n) {
        Object object;
        this.canvas3D = canvas3D;
        this.visible = true;
        this.antialiased = true;
        this.bounds = rectangle;
        this.offset = new Dimension(rectangle.x, rectangle.y);
        this.hasAlpha = bl || bl2;
        this.canvas = OverlayUtilities.createBufferedImage(rectangle.getSize(), this.hasAlpha);
        this.mouseManager = new ComponentMouseManager((Component)canvas3D, this);
        canvas3D.addComponentListener((ComponentListener)new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                OverlayBase.this.dirty(1);
            }
        });
        this.consoleBranchGroup = new BranchGroup();
        this.consoleTransformGroup = new TransformGroup();
        this.consoleTransformGroup.setCapability(18);
        this.consoleBranchGroup.addChild((Node)this.consoleTransformGroup);
        if (updateManager == null) {
            object = new UpdateControlBehavior(this);
            object.setSchedulingBounds((Bounds)new BoundingSphere());
            this.consoleBranchGroup.addChild((Node)object);
            updateManager = object;
        }
        this.updateManager = updateManager;
        this.renderAttributes = new RenderingAttributes();
        if (bl) {
            this.renderAttributes.setAlphaTestFunction(3);
            this.renderAttributes.setAlphaTestValue(0.0f);
        }
        this.renderAttributes.setDepthBufferEnable(true);
        this.renderAttributes.setDepthBufferWriteEnable(true);
        this.renderAttributes.setIgnoreVertexColors(true);
        this.renderAttributes.setCapability(5);
        this.renderAttributes.setCapability(6);
        this.polygonAttributes = new PolygonAttributes();
        this.polygonAttributes.setBackFaceNormalFlip(false);
        this.polygonAttributes.setCullFace(0);
        this.polygonAttributes.setPolygonMode(2);
        this.textureAttributes = new TextureAttributes();
        this.textureAttributes.setTextureMode(5);
        this.textureAttributes.setPerspectiveCorrectionMode(0);
        if (this.hasAlpha) {
            this.transparencyAttributes = new TransparencyAttributes(2, 1.0f);
            this.textureAttributes.setTextureBlendColor(new Color4f(0.0f, 0.0f, 0.0f, 1.0f));
        }
        object = OverlayUtilities.subdivide(rectangle.getSize(), 16, 256);
        SubOverlay[] subOverlayArray = this.subOverlay;
        synchronized (this.subOverlay) {
            this.subOverlay = new SubOverlay[((Vector)object).size()];
            int n2 = ((Vector)object).size();
            for (int i = 0; i < n2; ++i) {
                Rectangle rectangle2 = (Rectangle)((Vector)object).get(i);
                this.subOverlay[i] = new SubOverlay(this, rectangle2, n);
                this.consoleTransformGroup.addChild((Node)this.subOverlay[i].getShape());
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            this.initialize();
            for (int i = this.dirtyCheck.length - 1; i >= 0; --i) {
                this.dirtyCheck[i] = true;
            }
            this.repaint();
            return;
        }
    }

    protected void initialize() {
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public void setUpdateManager(UpdateManager updateManager) {
        this.updateManager = updateManager;
        updateManager.updateRequested();
    }

    public void setOffset(Dimension dimension) {
        this.setOffset(dimension.width, dimension.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffset(int n, int n2) {
        if (this.offset.width != n || this.offset.height != n2) {
            Dimension dimension = this.offset;
            synchronized (dimension) {
                this.offset.width = n;
                this.offset.height = n2;
                this.dirty(1);
            }
        }
    }

    public void setRelativePosition(int[] nArray) {
        this.setRelativePosition(this.relativePosition[0], this.relativePosition[1]);
    }

    public void setRelativePosition(int n, int n2) {
        if (this.relativePosition[0] != n || this.relativePosition[1] != n2) {
            this.relativePosition[0] = n;
            this.relativePosition[1] = n2;
            this.dirty(1);
        }
    }

    public BranchGroup getRoot() {
        return this.consoleBranchGroup;
    }

    public boolean hasAlphaComponent() {
        return this.hasAlpha;
    }

    public void setAntialiased(boolean bl) {
        if (this.antialiased != bl) {
            this.antialiased = bl;
            this.repaint();
        }
    }

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public Canvas3D getCanvas() {
        return this.canvas3D;
    }

    public RenderingAttributes getRenderingAttributes() {
        return this.renderAttributes;
    }

    public PolygonAttributes getPolygonAttributes() {
        return this.polygonAttributes;
    }

    public TextureAttributes getTextureAttributes() {
        return this.textureAttributes;
    }

    public TransparencyAttributes getTransparencyAttributes() {
        return this.transparencyAttributes;
    }

    protected Graphics2D getGraphics() {
        if (this.backgroundMode == 1 && this.backgroundImage != null) {
            this.canvas.setData(this.backgroundImage.getRaster());
        }
        Graphics2D graphics2D = (Graphics2D)this.canvas.getGraphics();
        if (this.antialiased) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return graphics2D;
    }

    public void repaint() {
        if (!this.painting) {
            this.painting = true;
            Graphics2D graphics2D = this.getGraphics();
            this.paint(graphics2D);
            graphics2D.dispose();
            this.updateBuffer(this.canvas, -1);
            this.setActiveBuffer(-1);
            this.painting = false;
        } else {
            System.err.println("Skipped paint in: " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBuffer(BufferedImage bufferedImage, int n) {
        SubOverlay[] subOverlayArray = this.subOverlay;
        synchronized (this.subOverlay) {
            for (int i = this.subOverlay.length - 1; i >= 0; --i) {
                this.subOverlay[i].updateBuffer(bufferedImage, n);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.dirty(0);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void paint(Graphics2D graphics2D) {
    }

    protected void setActiveBuffer(int n) {
        this.activeBuffer = n;
        this.dirty(2);
    }

    public void setBackgroundColor(Color color) {
        int[] nArray = new int[this.bounds.width * this.bounds.height];
        int n = color.getRGB();
        for (int i = nArray.length - 1; i >= 0; --i) {
            nArray[i] = n;
        }
        this.getBackgroundImage().setRGB(0, 0, this.bounds.width, this.bounds.height, nArray, 0, this.bounds.width);
        this.repaint();
    }

    public BufferedImage getBackgroundImage() {
        if (this.backgroundImage == null) {
            this.backgroundImage = OverlayUtilities.createBufferedImage(this.bounds.getSize(), this.hasAlpha);
        }
        return this.backgroundImage;
    }

    public void setBackgroundImage(BufferedImage bufferedImage) {
        if (this.backgroundImage != bufferedImage) {
            this.backgroundImage = bufferedImage;
            this.repaint();
        }
    }

    public void setBackgroundMode(int n) {
        if (this.backgroundMode != n) {
            this.backgroundMode = n;
            this.repaint();
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseManager.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseManager.removeMouseListener(mouseListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncPosition() {
        Rectangle rectangle = this.bounds;
        synchronized (rectangle) {
            Dimension dimension = this.canvas3D.getSize();
            OverlayUtilities.repositonBounds(this.bounds, this.relativePosition, dimension, this.offset);
            double d = this.canvas3D.getView().getFieldOfView();
            double d2 = 2.0 * Math.tan(d / 2.0) * (double)2.1f;
            double d3 = d2 / dimension.getWidth();
            double d4 = dimension.getHeight() * d3;
            Point point = new Point(this.bounds.x, dimension.height - this.bounds.height - this.bounds.y);
            Transform3D transform3D = new Transform3D();
            transform3D.setTranslation(new Vector3d(-d2 / 2.0 + point.getX() * d3, -d4 / 2.0 + point.getY() * d3, (double)-2.1f));
            transform3D.setScale(d3);
            this.consoleTransformGroup.setTransform(transform3D);
            this.dirtyCheck[1] = false;
        }
    }

    private void syncVisible() {
        this.renderAttributes.setVisible(this.visible);
        this.dirtyCheck[0] = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncActiveBuffer() {
        SubOverlay[] subOverlayArray = this.subOverlay;
        synchronized (this.subOverlay) {
            for (int i = this.subOverlay.length - 1; i >= 0; --i) {
                this.subOverlay[i].setActiveBufferIndex(this.activeBuffer);
            }
            this.dirtyCheck[2] = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void dirty(int n) {
        this.dirtyCheck[n] = true;
        if (this.updateManager != null) {
            this.updateManager.updateRequested();
        } else {
            System.err.println("Null update manager in: " + this);
        }
    }

    public void update() {
        if (this.dirtyCheck[1]) {
            this.syncPosition();
        }
        if (this.dirtyCheck[0]) {
            this.syncVisible();
        }
        if (this.dirtyCheck[2]) {
            this.syncActiveBuffer();
        }
    }
}

