/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.overlay;

import com.xith.java3d.overlay.OverlayBase;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.media.j3d.Canvas3D;

public class ImageButtonOverlay
extends OverlayBase {
    public static final int INACTIVE_IMAGE = 0;
    public static final int ACTIVE_IMAGE = 1;
    public static final int CLICKED_IMAGE = 2;
    public static final int MOUSEOVER_IMAGE = 3;
    static final int numBuffers = 4;
    boolean[] hasImage = new boolean[4];
    boolean mouseOver = false;
    boolean stuck = false;
    boolean clicked = false;

    public ImageButtonOverlay(Canvas3D canvas3D, Rectangle rectangle, BufferedImage[] bufferedImageArray) {
        this(canvas3D, rectangle, true, false, bufferedImageArray);
    }

    public ImageButtonOverlay(Canvas3D canvas3D, Rectangle rectangle, boolean bl, boolean bl2, BufferedImage[] bufferedImageArray) {
        super(canvas3D, rectangle, bl, bl2, null, 4);
        for (int i = bufferedImageArray.length - 1; i >= 0; --i) {
            boolean bl3 = this.hasImage[i] = bufferedImageArray[i] != null;
            if (!this.hasImage[i]) continue;
            this.updateBuffer(bufferedImageArray[i], i);
        }
        this.setActiveBuffer(0);
        this.addMouseListener(new MouseListener(){

            public void mouseEntered(MouseEvent mouseEvent) {
                ImageButtonOverlay.this.mouseOver = true;
                ImageButtonOverlay.this.switchButtons();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ImageButtonOverlay.this.mouseOver = false;
                ImageButtonOverlay.this.clicked = false;
                ImageButtonOverlay.this.switchButtons();
            }

            public void mousePressed(MouseEvent mouseEvent) {
                ImageButtonOverlay.this.clicked = true;
                ImageButtonOverlay.this.switchButtons();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ImageButtonOverlay.this.clicked = false;
                ImageButtonOverlay.this.switchButtons();
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ImageButtonOverlay.this.stuck = !ImageButtonOverlay.this.stuck;
                ImageButtonOverlay.this.switchButtons();
            }
        });
    }

    protected synchronized void switchButtons() {
        if (this.mouseOver && this.clicked && this.hasImage[2]) {
            this.setActiveBuffer(2);
        } else if (this.mouseOver && this.hasImage[3]) {
            this.setActiveBuffer(3);
        } else if (this.stuck && this.hasImage[1]) {
            this.setActiveBuffer(1);
        } else if (this.hasImage[0]) {
            this.setActiveBuffer(0);
        } else {
            System.err.println("No images to choose from in ImageButtonOverlay");
        }
    }

    public void repaint() {
    }
}

