/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.overlay;

import com.xith.java3d.overlay.ScreenComponent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.event.EventListenerList;

public class ComponentMouseManager
implements MouseListener,
MouseMotionListener {
    EventListenerList listenerList = new EventListenerList();
    ScreenComponent subComponent;
    boolean mouseOver = false;
    boolean stuck = false;
    boolean clicked = false;

    public ComponentMouseManager(Component component, ScreenComponent screenComponent) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        this.subComponent = screenComponent;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.subComponent.getBounds().contains(mouseEvent.getPoint())) {
            if (!this.mouseOver) {
                this.mouseOver = true;
                this.fireMouseEntered(mouseEvent);
            }
            this.fireMouseMoved(mouseEvent);
        } else if (this.mouseOver) {
            this.mouseOver = false;
            this.fireMouseExited(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.subComponent.getBounds().contains(mouseEvent.getPoint())) {
            if (!this.mouseOver) {
                this.mouseOver = true;
                this.fireMouseEntered(mouseEvent);
            }
            this.fireMouseDragged(mouseEvent);
        } else if (this.mouseOver) {
            this.mouseOver = false;
            this.fireMouseExited(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mouseOver) {
            this.mouseOver = false;
            this.fireMouseExited(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mouseOver) {
            this.clicked = true;
            this.fireMousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseOver) {
            this.fireMouseReleased(mouseEvent);
            if (this.clicked) {
                this.clicked = false;
                this.fireMouseClicked(mouseEvent);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.listenerList.add(MouseListener.class, mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.listenerList.remove(MouseListener.class, mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.listenerList.add(MouseMotionListener.class, mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.listenerList.remove(MouseMotionListener.class, mouseMotionListener);
    }

    public void fireMouseMoved(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MouseMotionListener.class) continue;
            ((MouseMotionListener)objectArray[i + 1]).mouseMoved(mouseEvent);
        }
    }

    public void fireMouseDragged(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MouseMotionListener.class) continue;
            ((MouseMotionListener)objectArray[i + 1]).mouseDragged(mouseEvent);
        }
    }

    public void fireMouseEntered(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MouseListener.class) continue;
            ((MouseListener)objectArray[i + 1]).mouseEntered(mouseEvent);
        }
    }

    public void fireMouseExited(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MouseListener.class) continue;
            ((MouseListener)objectArray[i + 1]).mouseExited(mouseEvent);
        }
    }

    public void fireMouseClicked(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MouseListener.class) continue;
            ((MouseListener)objectArray[i + 1]).mouseClicked(mouseEvent);
        }
    }

    public void fireMousePressed(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MouseListener.class) continue;
            ((MouseListener)objectArray[i + 1]).mousePressed(mouseEvent);
        }
    }

    public void fireMouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MouseListener.class) continue;
            ((MouseListener)objectArray[i + 1]).mouseReleased(mouseEvent);
        }
    }
}

