/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.overlay;

import com.xith.java3d.overlay.LabelOverlay;
import com.xith.java3d.overlay.OverlayScroller;
import com.xith.java3d.overlay.ScrollEvent;
import com.xith.java3d.overlay.ScrollEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Stack;

public class ChatManager
implements KeyListener,
ScrollEventListener {
    OverlayScroller scroller;
    int numLines;
    StringBuffer buffer = new StringBuffer();
    Stack history = new Stack();
    boolean ignorable = true;
    boolean skipKey = false;
    static final char[] punctuation = new char[]{'?', '.', ',', '\'', '\"', ';', '(', ')', '/', '\\', '!', '-', '=', '+', '_', ':', '<', '>', '$', '%', '*', '&', '^', '|', '~', '`', '@', '#', '{', '}', '[', ']'};

    public ChatManager(OverlayScroller overlayScroller) {
        this.scroller = overlayScroller;
        overlayScroller.addScrollEventListener(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.ignorable = true;
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.scrollUp();
                break;
            }
            case 8: {
                if (this.buffer.length() > 0) {
                    this.buffer.setLength(this.buffer.length() - 1);
                    this.ignorable = false;
                    break;
                }
                this.scrollDown();
                break;
            }
            case 97: {
                this.scroller.setRelativePosition(1, 1);
                this.skipKey = true;
                break;
            }
            case 98: {
                this.scroller.setRelativePosition(3, 1);
                this.skipKey = true;
                break;
            }
            case 99: {
                this.scroller.setRelativePosition(0, 1);
                this.skipKey = true;
                break;
            }
            case 100: {
                this.scroller.setRelativePosition(1, 3);
                this.skipKey = true;
                break;
            }
            case 101: {
                this.scroller.setRelativePosition(3, 3);
                this.skipKey = true;
                break;
            }
            case 102: {
                this.scroller.setRelativePosition(0, 3);
                this.skipKey = true;
                break;
            }
            case 103: {
                this.scroller.setRelativePosition(1, 0);
                this.skipKey = true;
                break;
            }
            case 104: {
                this.scroller.setRelativePosition(3, 0);
                this.skipKey = true;
                break;
            }
            case 105: {
                this.scroller.setRelativePosition(0, 0);
                this.skipKey = true;
                break;
            }
            default: {
                this.ignorable = true;
            }
        }
        if (!this.ignorable) {
            ((LabelOverlay)this.scroller.getLine(0)).setText(this.buffer.toString());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (!this.skipKey) {
            char c = keyEvent.getKeyChar();
            if (Character.isLetterOrDigit(c) || c == ' ' || ChatManager.isPunctuation(c)) {
                this.buffer.append(c);
                ((LabelOverlay)this.scroller.getLine(0)).setText(this.buffer.toString());
            }
        } else {
            this.skipKey = false;
        }
    }

    public void itemScrolled(ScrollEvent scrollEvent) {
        switch (scrollEvent.getScrollType()) {
            case 0: {
                ((LabelOverlay)scrollEvent.getScrolledItem()).setText("");
                break;
            }
            case 1: {
                int n = this.history.size() - this.scroller.getNumLines();
                if (n < 0) break;
                ((LabelOverlay)scrollEvent.getScrolledItem()).setText(this.history.get(n).toString());
            }
        }
    }

    public void scrollUp() {
        this.history.push(this.buffer);
        this.buffer = new StringBuffer();
        this.scroller.scroll(0, 1);
    }

    public void scrollDown() {
        if (this.history.size() > 0) {
            this.scroller.scroll(this.scroller.getNumLines() - 1, -1);
            this.buffer = (StringBuffer)this.history.pop();
        }
    }

    public void pushLine(String string) {
        this.scrollUp();
        this.buffer = new StringBuffer(string);
    }

    public static boolean isPunctuation(char c) {
        boolean bl = false;
        for (int i = punctuation.length - 1; i >= 0 && !bl; --i) {
            bl = c == punctuation[i];
        }
        return bl;
    }
}

