/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.util;

import java.lang.reflect.Method;

public class Runner
implements Runnable {
    Object target;
    Method toInvoke;
    long interval;
    boolean running = false;
    boolean killed = false;
    Thread runner = new Thread(this);

    public Runner(Object object, Method method) {
        this(object, method, 1000L, false);
    }

    public Runner(Object object, Method method, long l) {
        this(object, method, l, false);
    }

    public Runner(Object object, Method method, boolean bl) {
        this(object, method, 1000L, bl);
    }

    public Runner(Object object, Method method, long l, boolean bl) {
        this.setTargetObject(object);
        this.setTargetMethod(method);
        this.setInterval(l);
        this.setRunning(bl);
        this.runner.start();
    }

    public void setTargetObject(Object object) {
        this.target = object;
    }

    public Object getTargetObject() {
        return this.target;
    }

    public void setTargetMethod(Method method) {
        this.toInvoke = method;
    }

    public Method getTargetMethod() {
        return this.toInvoke;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(long l) {
        Runner runner = this;
        synchronized (runner) {
            this.interval = l;
            this.notifyAll();
        }
    }

    public long getInterval() {
        return this.interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long l) {
        if (this.running) {
            Thread thread = this.runner;
            synchronized (thread) {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void setPriority(int n) {
        this.runner.setPriority(n);
    }

    public int getPriority() {
        return this.runner.getPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean bl) {
        Thread thread;
        if (this.killed) {
            this.killed = false;
            thread = this.runner;
            synchronized (thread) {
                Thread thread2 = new Thread(this);
                thread2.setPriority(this.runner.getPriority());
                this.runner = thread2;
                thread2.start();
            }
        }
        this.running = bl;
        thread = this.runner;
        synchronized (thread) {
            this.runner.notify();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die() {
        this.killed = true;
        Thread thread = this.runner;
        synchronized (thread) {
            this.runner.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.killed) {
            Thread thread = this.runner;
            synchronized (thread) {
                while (!this.running && !this.killed) {
                    try {
                        this.runner.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.killed) continue;
            thread = this.runner;
            synchronized (thread) {
                try {
                    Thread.sleep(this.interval);
                    try {
                        this.toInvoke.invoke(this.target, (Object[])null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        this.running = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.running = false;
    }
}

