/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.util;

import java.io.File;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

public class ConfigurableFileFilter
extends FileFilter {
    String[] extensions;
    String description = new String();
    boolean appendBlob = true;
    ConfigurableFileFilter[] subFilters;
    int maxExtensions = 4;

    public ConfigurableFileFilter(String string) {
        this.setExtension(string);
        this.description = this.toBlob();
    }

    public ConfigurableFileFilter(String string, String string2) {
        this.setExtension(string);
        this.setDescription(string2);
    }

    public ConfigurableFileFilter(String[] stringArray) {
        this.setExtensions(stringArray, null);
        this.description = this.toBlob();
    }

    public ConfigurableFileFilter(String[] stringArray, String string) {
        this.setExtensions(stringArray, null);
        this.setDescription(string);
    }

    public ConfigurableFileFilter(String[] stringArray, String[] stringArray2) {
        this.setExtensions(stringArray, stringArray2);
        this.description = this.toBlob();
    }

    public ConfigurableFileFilter(String[] stringArray, String[] stringArray2, String string) {
        this.setExtensions(stringArray, stringArray2);
        this.setDescription(string);
    }

    public void setExtension(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.extensions = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            this.extensions[n++] = stringTokenizer.nextToken();
        }
    }

    public void setExtensions(String[] stringArray, String[] stringArray2) {
        this.extensions = null;
        this.subFilters = new ConfigurableFileFilter[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.subFilters[i] = stringArray2 != null && i < stringArray2.length ? new ConfigurableFileFilter(stringArray[i], stringArray2[i]) : new ConfigurableFileFilter(stringArray[i]);
        }
    }

    public boolean accept(File file) {
        boolean bl = false;
        if (this.extensions != null) {
            if (file.isDirectory()) {
                bl = true;
            }
            String string = ConfigurableFileFilter.getFilenameExtension(file.getName());
            for (int i = 0; i < this.extensions.length && !bl; ++i) {
                bl = string.equals(this.extensions[i]);
            }
        } else {
            for (int i = 0; i < this.subFilters.length && !bl; ++i) {
                bl = this.subFilters[i].accept(file);
            }
        }
        return bl;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (this.appendBlob) {
            string = string + " (" + this.toBlob() + ")";
        }
        this.description = string;
    }

    public String toBlob() {
        String string = new String();
        if (this.extensions != null && this.extensions.length > 0 && this.maxExtensions > 0) {
            int n = 0;
            string = string + "*." + this.extensions[n];
            for (n = 1; n < this.maxExtensions && n < this.extensions.length; ++n) {
                string = string + ", *." + this.extensions[n];
            }
            if (n < this.extensions.length) {
                string = string + ", ...";
            }
        } else if (this.extensions == null && this.subFilters.length > 0 && this.maxExtensions > 0) {
            int n = 0;
            string = string + this.subFilters[n].toBlob();
            for (n = 1; n < this.maxExtensions && n < this.subFilters.length; ++n) {
                string = string + ", " + this.subFilters[n].toBlob();
            }
            if (n < this.subFilters.length) {
                string = string + ", ...";
            }
        }
        return string;
    }

    public ConfigurableFileFilter[] getSubFilters() {
        return this.subFilters;
    }

    public static String getFilenameExtension(String string) {
        int n = string.lastIndexOf(46);
        String string2 = null;
        string2 = n >= string.length() ? "" : (n < 0 ? string.toLowerCase() : string.substring(n + 1).toLowerCase());
        return string2;
    }
}

