/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.ui.test;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.himinbi.ui.OrientedJLabel;
import org.himinbi.util.Runner;

public class LabelRotationTest
extends JPanel {
    OrientedJLabel label;
    int numMajorTicks = 12;
    int numMinorTicks = 36;
    JSlider thetaSlider = new JSlider(1, 0, 360, 0);
    int sliderLength = this.thetaSlider.getMaximum() - this.thetaSlider.getMinimum();
    int stepSize = this.sliderLength / 360;
    JTextField textField;
    Runner runner;

    public LabelRotationTest() {
        try {
            this.runner = new Runner((Object)this, this.getClass().getMethod("step", null), 50L);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace(System.err);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.label = new OrientedJLabel("Spinning Text", 0.0, 0){
            {
                this.setBorder(BorderFactory.createBevelBorder(1));
                this.addMouseMotionListener(new MouseMotionAdapter(){

                    public void mouseDragged(MouseEvent mouseEvent) {
                        this.setAngle(mouseEvent.getPoint());
                    }
                });
                this.addMouseListener(new MouseAdapter(){

                    public void mouseDown(MouseEvent mouseEvent) {
                        this.setAngle(mouseEvent.getPoint());
                    }
                });
            }

            protected void setAngle(Point2D point2D) {
                Point2D.Double double_ = new Point2D.Double(this.getWidth() / 2, this.getHeight() / 2);
                int n = 0;
                n = point2D.getY() > ((Point2D)double_).getY() ? (int)Math.toDegrees(Math.atan2(point2D.getY() - ((Point2D)double_).getY(), point2D.getX() - ((Point2D)double_).getX())) : (int)Math.toDegrees(Math.atan2(((Point2D)double_).getY() - point2D.getY(), ((Point2D)double_).getX() - point2D.getX())) + 180;
                LabelRotationTest.this.thetaSlider.setValue(n);
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = 3;
        gridBagLayout.setConstraints(this.label, gridBagConstraints);
        this.add(this.label);
        JLabel jLabel = new JLabel("Angle:");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        this.thetaSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LabelRotationTest.this.label.setOrientation(Math.toRadians(LabelRotationTest.this.thetaSlider.getValue()));
            }
        });
        this.thetaSlider.setMajorTickSpacing(this.sliderLength / this.numMajorTicks);
        this.thetaSlider.setMinorTickSpacing(this.sliderLength / this.numMinorTicks);
        this.thetaSlider.setPaintTicks(true);
        this.thetaSlider.setPaintLabels(true);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.thetaSlider, gridBagConstraints);
        this.add(this.thetaSlider);
        JButton jButton = new JButton("Animate"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        LabelRotationTest.this.runner.setRunning(!LabelRotationTest.this.runner.isRunning());
                        if (LabelRotationTest.this.runner.isRunning()) {
                            this.setText("Stop");
                        } else {
                            this.setText("Animate");
                        }
                    }
                });
            }
        };
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
        this.textField = new JTextField(this.label.getText());
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                LabelRotationTest.this.label.setText(LabelRotationTest.this.textField.getText());
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                LabelRotationTest.this.label.setText(LabelRotationTest.this.textField.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                LabelRotationTest.this.label.setText(LabelRotationTest.this.textField.getText());
            }
        });
        gridBagLayout.setConstraints(this.textField, gridBagConstraints);
        this.add(this.textField);
    }

    public void step() {
        this.thetaSlider.setValue(this.thetaSlider.getMinimum() + (this.thetaSlider.getValue() + this.stepSize) % this.sliderLength);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Label Rotation Test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new LabelRotationTest());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

