/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;

public class OrientedJLabel
extends JLabel {
    double angle;
    Font baseFont;
    boolean fontSet = true;
    Object antialiasHint = RenderingHints.VALUE_ANTIALIAS_ON;
    Object fractionalMetricsHint = RenderingHints.VALUE_FRACTIONALMETRICS_ON;

    public OrientedJLabel() {
        this("", 0.0, 0);
    }

    public OrientedJLabel(String string) {
        this(string, 0.0, 0);
    }

    public OrientedJLabel(String string, double d) {
        this(string, d, 0);
    }

    public OrientedJLabel(String string, double d, int n) {
        super(string, n);
        this.baseFont = this.getFont();
        this.setOrientation(d);
    }

    public void setOrientation(double d) {
        if (d != this.angle) {
            super.setFont(this.rotateFont(this.baseFont, d));
            this.fixBounds();
            this.angle = d;
        }
    }

    public double getOrientation() {
        return this.angle;
    }

    public void setFont(Font font) {
        this.baseFont = font;
        super.setFont(this.rotateFont(font, this.angle));
        this.fixBounds();
    }

    protected void fixBounds() {
        if (this.fontSet) {
            Rectangle2D rectangle2D = this.getFont().createGlyphVector(((Graphics2D)this.getGraphics()).getFontRenderContext(), this.getText()).getVisualBounds();
            Dimension dimension = new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
        }
    }

    public void setText(String string) {
        super.setText(string);
        this.setFont(this.baseFont);
    }

    public Font rotateFont(Font font, double d) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        Font font2 = font;
        if (graphics2D != null) {
            font2 = OrientedJLabel.rotateFont(font, graphics2D.getFontRenderContext(), this.getText(), d);
            this.fontSet = true;
        } else {
            this.fontSet = false;
        }
        return font2;
    }

    public static Font rotateFont(Font font, FontRenderContext fontRenderContext, String string, double d) {
        AffineTransform affineTransform = new AffineTransform();
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        double d2 = -0.5;
        if ((d %= Math.PI * 2) < 1.5707963267948966 || d > 4.71238898038469) {
            d2 *= 1.0 - Math.cos(d);
        }
        Rectangle2D rectangle2D = glyphVector.getVisualBounds();
        affineTransform.translate((rectangle2D.getWidth() + rectangle2D.getHeight()) * d2, 0.0);
        affineTransform.rotate(d, rectangle2D.getWidth() * 0.5, 0.0);
        return font == null ? font : font.deriveFont(affineTransform);
    }

    public void paintComponent(Graphics graphics) {
        if (!this.fontSet) {
            this.setFont(this.baseFont);
        }
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasHint);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.fractionalMetricsHint);
        super.paintComponent(graphics);
    }

    public Object getAntialiasKey() {
        return this.antialiasHint;
    }

    public void setAntiaiasHint(Object object) {
        this.antialiasHint = object;
    }

    public Object getFractionalMetricsHint() {
        return this.fractionalMetricsHint;
    }

    public void setFractionalMetricsHint(Object object) {
        this.fractionalMetricsHint = object;
    }
}

