/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.media.util;

import java.io.IOException;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSinkException;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;

public class MovieMaker
implements Runnable,
ControllerListener,
DataSinkListener {
    DataSource source;
    MediaLocator out;
    Thread me;
    boolean recording = false;
    Processor processor;
    ContentDescriptor outputContentDescriptor = new ContentDescriptor("video.quicktime");
    Object processorSync = new Object();
    boolean processorDone = false;
    boolean processorSuccess = true;
    Object dataSinkSync = new Object();
    boolean dataSinkDone = false;
    boolean dataSinkSuccess = true;

    public MovieMaker() {
        this(null, null);
    }

    public MovieMaker(DataSource dataSource) {
        this(dataSource, null);
    }

    public MovieMaker(DataSource dataSource, MediaLocator mediaLocator) {
        this.setDataSource(dataSource);
        this.setOutputLocator(mediaLocator);
    }

    public void setDataSource(DataSource dataSource) {
        if (this.recording) {
            // empty if block
        }
        this.source = dataSource;
    }

    public void setOutputLocator(MediaLocator mediaLocator) {
        if (this.recording) {
            // empty if block
        }
        this.out = mediaLocator;
    }

    public void start() {
        this.setRecording(true);
    }

    public void stop() {
        this.setRecording(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecording(boolean bl) {
        if (bl) {
            if (this.recording) {
                // empty if block
            }
            MovieMaker movieMaker = this;
            synchronized (movieMaker) {
                if (this.me == null || !this.me.isAlive()) {
                    this.me = new Thread(this);
                    this.me.start();
                }
            }
        } else if (this.processor != null && this.processor.getState() == 600) {
            this.processor.stop();
            this.processor.close();
        }
        this.recording = bl;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void run() {
        DataSink dataSink;
        try {
            this.source.connect();
        }
        catch (IOException iOException) {
            throw new Error("Could not connect source");
        }
        try {
            this.processor = Manager.createProcessor((DataSource)this.source);
        }
        catch (Exception exception) {
            throw new Error("Could not create processor");
        }
        this.processor.addControllerListener((ControllerListener)this);
        this.processor.configure();
        if (!this.waitForState(this.processor, 180)) {
            throw new Error("Failed to configure the processor");
        }
        this.processor.setContentDescriptor(this.outputContentDescriptor);
        this.processor.realize();
        if (!this.waitForState(this.processor, 300)) {
            throw new Error("Failed to realize the processor");
        }
        try {
            dataSink = Manager.createDataSink((DataSource)this.processor.getDataOutput(), (MediaLocator)this.out);
        }
        catch (NoDataSinkException noDataSinkException) {
            throw new Error("Failed to create a DataSink for: " + this.out);
        }
        try {
            dataSink.open();
        }
        catch (IOException iOException) {
            throw new Error("IOException opening data sink");
        }
        dataSink.addDataSinkListener((DataSinkListener)this);
        try {
            dataSink.start();
            this.processor.start();
        }
        catch (IOException iOException) {
            throw new Error("IO error during processing");
        }
        this.waitForDataSinkDone();
        try {
            dataSink.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.processor.removeControllerListener((ControllerListener)this);
        this.recording = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(Processor processor, int n) {
        this.processorDone = false;
        Object object = this.processorSync;
        synchronized (object) {
            try {
                while (processor.getState() < n && !this.processorDone) {
                    this.processorSync.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.processorSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent controllerEvent) {
        Object object = this.processorSync;
        synchronized (object) {
            if (controllerEvent instanceof ConfigureCompleteEvent || controllerEvent instanceof RealizeCompleteEvent || controllerEvent instanceof PrefetchCompleteEvent) {
                this.processorDone = true;
                this.processorSuccess = true;
            } else if (controllerEvent instanceof ResourceUnavailableEvent) {
                this.processorDone = true;
                this.processorSuccess = false;
            } else if (controllerEvent instanceof EndOfMediaEvent) {
                controllerEvent.getSourceController().stop();
                controllerEvent.getSourceController().close();
            }
            this.processorSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForDataSinkDone() {
        this.dataSinkDone = false;
        Object object = this.dataSinkSync;
        synchronized (object) {
            try {
                while (!this.dataSinkDone) {
                    this.dataSinkSync.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.dataSinkSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSinkUpdate(DataSinkEvent dataSinkEvent) {
        Object object = this.dataSinkSync;
        synchronized (object) {
            if (dataSinkEvent instanceof EndOfStreamEvent) {
                this.dataSinkDone = true;
                this.dataSinkSuccess = true;
            } else if (dataSinkEvent instanceof DataSinkErrorEvent) {
                this.dataSinkDone = true;
                this.dataSinkSuccess = false;
            }
            this.dataSinkSync.notifyAll();
        }
    }
}

