/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.media.util;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.media.Buffer;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferStream;
import org.apache.log4j.Logger;

public class FakeTransferHandler
implements BufferTransferHandler {
    String filePrefix = "FrameCapture_";
    String filePostfix = ".jpeg";
    NumberFormat format = new DecimalFormat("00000");
    static Logger log = Logger.getLogger((String)"FTH");

    public FakeTransferHandler() {
        log.debug((Object)"FakeTransferHandler created:");
    }

    public void transferData(PushBufferStream pushBufferStream) {
        try {
            Buffer buffer = new Buffer();
            pushBufferStream.read(buffer);
            if (!buffer.isEOM()) {
                Dimension dimension = ((VideoFormat)buffer.getFormat()).getSize();
                log.info((Object)("Writing file: " + buffer.getSequenceNumber() + ": <" + dimension.width + ", " + dimension.height + ">"));
                BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
                bufferedImage.setRGB(0, 0, dimension.width, dimension.height, (int[])buffer.getData(), 0, dimension.width);
                FileOutputStream fileOutputStream = new FileOutputStream(this.filePrefix + this.format.format(buffer.getSequenceNumber()) + this.filePostfix);
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
                jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage).setQuality(0.3f, false);
                jPEGImageEncoder.encode(bufferedImage);
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

