/*
 * Decompiled with CFR 0.152.
 */
package com.xith.java3d.overlay;

import com.xith.java3d.overlay.OverlayBase;
import com.xith.java3d.overlay.UpdateManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnActivation;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedTime;

public class LabelOverlay
extends OverlayBase {
    private AttributedString text;
    private int visibleLength = 0;
    private int textLength = 0;
    private int typingDelta = 0;
    private Font font;
    private Color color;
    TypingBehavior typer;
    boolean typing = false;
    Object typingBlock = new Object();

    public LabelOverlay(Canvas3D canvas3D, Rectangle rectangle) {
        this(canvas3D, rectangle, "");
    }

    public LabelOverlay(Canvas3D canvas3D, Rectangle rectangle, String string) {
        this(canvas3D, rectangle, string, new Font("Helvetica", 1, 14), Color.red, null);
    }

    public LabelOverlay(Canvas3D canvas3D, Rectangle rectangle, String string, Font font, Color color) {
        this(canvas3D, rectangle, string, font, color, null);
    }

    public LabelOverlay(Canvas3D canvas3D, Rectangle rectangle, String string, Font font, Color color, UpdateManager updateManager) {
        super(canvas3D, rectangle, updateManager);
        this.font = font;
        this.color = color;
        this.setText(string);
    }

    public LabelOverlay(Canvas3D canvas3D, Rectangle rectangle, AttributedString attributedString) {
        this(canvas3D, rectangle, attributedString, null);
    }

    public LabelOverlay(Canvas3D canvas3D, Rectangle rectangle, AttributedString attributedString, UpdateManager updateManager) {
        super(canvas3D, rectangle, updateManager);
        this.setText(attributedString);
    }

    protected void initialize() {
        this.typer = new TypingBehavior();
        this.typer.setSchedulingBounds((Bounds)new BoundingSphere());
        this.getRoot().addChild((Node)this.typer);
        this.setBackgroundColor(new Color(0, 0, 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics2D) {
        if (this.text != null) {
            AttributedString attributedString = this.text;
            synchronized (attributedString) {
                AttributedCharacterIterator attributedCharacterIterator = this.text.getIterator(null, 0, this.visibleLength);
                if (attributedCharacterIterator.getEndIndex() > 0) {
                    TextLayout textLayout = new TextLayout(attributedCharacterIterator, graphics2D.getFontRenderContext());
                    textLayout.draw(graphics2D, 0.0f, 3 * this.getBounds().height / 4);
                }
            }
        }
    }

    public void setColor(Color color) {
        if (!this.color.equals(color)) {
            this.color = color;
            if (this.text != null) {
                this.text.addAttribute(TextAttribute.FOREGROUND, color);
                this.repaint();
            }
        }
    }

    public void setFont(Font font) {
        if (!this.font.equals(font)) {
            this.font = font;
            if (this.text != null) {
                this.text.addAttribute(TextAttribute.FONT, font);
                this.repaint();
            }
        }
    }

    public void setText(String string) {
        this.setText(string, string.length());
    }

    public void setText(String string, int n) {
        this.setText(LabelOverlay.createAttributedString(string, this.font, this.color), n);
    }

    public void setText(AttributedString attributedString) {
        if (attributedString != null) {
            this.setText(attributedString, attributedString.getIterator().getEndIndex() + 1);
        }
    }

    public void setText(AttributedString attributedString, int n) {
        if (this.text != attributedString) {
            this.text = attributedString;
            this.textLength = attributedString.getIterator().getEndIndex();
            this.visibleLength = 0;
            this.typingDelta = n;
            this.typer.type();
        }
    }

    public void backspace(int n) {
        this.visibleLength = Math.max(0, this.visibleLength - n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTyping() {
        this.visibleLength = Math.min(this.textLength, this.visibleLength + this.typingDelta);
        this.repaint();
        boolean bl = this.typing = this.visibleLength < this.textLength;
        if (!this.typing) {
            Object object = this.typingBlock;
            synchronized (object) {
                this.typingBlock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTyping() {
        while (this.typing) {
            Object object = this.typingBlock;
            synchronized (object) {
                try {
                    this.typingBlock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void setTypingSpeed(long l) {
        this.typer.setTypingSpeed(l);
    }

    public int getVisibleLength() {
        return this.visibleLength;
    }

    public boolean isTyping() {
        return this.typing;
    }

    public static AttributedString createAttributedString(String string, Font font, Color color) {
        AttributedString attributedString = null;
        if (string.length() > 0) {
            attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, font);
            attributedString.addAttribute(TextAttribute.FOREGROUND, color);
        }
        return attributedString;
    }

    class TypingBehavior
    extends Behavior {
        int START_TYPING = 1;
        WakeupOnBehaviorPost postWakeup = new WakeupOnBehaviorPost((Behavior)this, this.START_TYPING);
        WakeupOnElapsedTime timeWakeup = new WakeupOnElapsedTime(100L);

        TypingBehavior() {
        }

        public void initialize() {
            this.wakeupOn((WakeupCondition)new WakeupOnActivation());
        }

        public void type() {
            this.postId(this.START_TYPING);
            LabelOverlay.this.typing = true;
        }

        public void processStimulus(Enumeration enumeration) {
            LabelOverlay.this.updateTyping();
            if (LabelOverlay.this.typing) {
                this.wakeupOn((WakeupCondition)this.timeWakeup);
            } else {
                this.wakeupOn((WakeupCondition)this.postWakeup);
            }
        }

        public void setTypingSpeed(long l) {
            this.timeWakeup = new WakeupOnElapsedTime(l);
        }
    }
}

