/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.j3d.test;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.media.j3d.Alpha;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Group;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.swing.JApplet;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class DetachTest
extends JApplet
implements KeyListener {
    int speed;
    static float defaultLength = 1.0f;
    static double defaultCenterOffset = 3.0;
    static int defaultNumSections = 20;
    static int defaultSpeed = 3000;
    Alpha rotationAlpha;
    BranchGroup[] cubeGroup;
    TransformGroup[] offset;
    TransformInterpolator[] rotator;
    TransformGroup[] initialPosition;
    Group holder;
    final int UP = 1;
    final int DOWN = 2;
    int direction = 0;
    int index = 0;
    boolean paused = false;
    Vector3d offsetVector = new Vector3d();

    public DetachTest() {
        this(defaultLength, defaultCenterOffset, defaultNumSections, defaultSpeed);
    }

    public DetachTest(float f) {
        this(f, defaultCenterOffset, defaultNumSections, defaultSpeed);
    }

    public DetachTest(float f, double d) {
        this(f, d, defaultNumSections, defaultSpeed);
    }

    public DetachTest(float f, double d, int n) {
        this(f, d, n, defaultSpeed);
    }

    public DetachTest(float f, double d, int n, int n2) {
        this.speed = n2;
        VirtualUniverse virtualUniverse = new VirtualUniverse();
        Locale locale = new Locale(virtualUniverse);
        BranchGroup branchGroup = new BranchGroup();
        this.holder = new Group();
        this.holder.setCapability(13);
        this.holder.setCapability(14);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
        Background background = new Background(new Color3f(0.11372549f, 0.16862746f, 0.6f));
        background.setApplicationBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)background);
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        branchGroup.addChild((Node)transformGroup);
        MouseRotate mouseRotate = new MouseRotate(transformGroup);
        mouseRotate.setSchedulingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)mouseRotate);
        n = Math.max(n, 1);
        this.offsetVector = new Vector3d(d, 0.0, 0.0);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(this.offsetVector);
        this.initialPosition = new TransformGroup[n];
        TransformGroup[] transformGroupArray = new TransformGroup[n];
        this.offset = new TransformGroup[n];
        this.cubeGroup = new BranchGroup[n];
        this.rotationAlpha = new Alpha(-1, 1, 0L, 0L, (long)n2, 0L, 0L, 0L, 0L, 0L);
        Transform3D transform3D2 = new Transform3D();
        this.rotator = new RotationInterpolator[n];
        this.index = 0;
        while (this.index < n) {
            transform3D2.rotX((double)this.index * Math.PI * 2.0 / (double)n);
            Transform3D transform3D3 = new Transform3D();
            transform3D3.rotZ((double)this.index * Math.PI * 2.0 / (double)n);
            transform3D3.mul(transform3D);
            this.initialPosition[this.index] = new TransformGroup(transform3D3);
            this.initialPosition[this.index].setCapability(17);
            this.initialPosition[this.index].setCapability(18);
            transformGroup.addChild((Node)this.initialPosition[this.index]);
            transformGroupArray[this.index] = new TransformGroup();
            transformGroupArray[this.index].setCapability(17);
            transformGroupArray[this.index].setCapability(18);
            this.initialPosition[this.index].addChild((Node)transformGroupArray[this.index]);
            this.offset[this.index] = new TransformGroup(transform3D);
            this.offset[this.index].setCapability(13);
            this.offset[this.index].setCapability(14);
            this.offset[this.index].setCapability(18);
            transformGroupArray[this.index].addChild((Node)this.offset[this.index]);
            this.cubeGroup[this.index] = new BranchGroup();
            this.cubeGroup[this.index].setCapability(17);
            this.offset[this.index].addChild((Node)this.cubeGroup[this.index]);
            this.cubeGroup[this.index].addChild((Node)new ColorCube((double)f));
            this.rotator[this.index] = new RotationInterpolator(this.rotationAlpha, transformGroupArray[this.index], transform3D2, 0.0f, (float)Math.PI * 2);
            this.rotator[this.index].setSchedulingBounds((Bounds)boundingSphere);
            transformGroupArray[this.index].addChild((Node)this.rotator[this.index]);
            ++this.index;
        }
        this.index = n - 1;
        this.direction = 2;
        Canvas3D canvas3D = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        View view = new View();
        view.setPhysicalBody(new PhysicalBody());
        view.setPhysicalEnvironment(new PhysicalEnvironment());
        view.setBackClipDistance(5000.0);
        view.addCanvas3D(canvas3D);
        ViewPlatform viewPlatform = new ViewPlatform();
        view.attachViewPlatform(viewPlatform);
        transform3D.setTranslation(new Vector3d(0.0, 0.0, ((double)f + d) * 7.0));
        TransformGroup transformGroup2 = new TransformGroup(transform3D);
        transformGroup2.setCapability(17);
        transformGroup2.setCapability(18);
        branchGroup.addChild((Node)transformGroup2);
        transformGroup2.addChild((Node)viewPlatform);
        MouseZoom mouseZoom = new MouseZoom(transformGroup2);
        mouseZoom.setSchedulingBounds((Bounds)boundingSphere);
        transformGroup2.addChild((Node)mouseZoom);
        this.getContentPane().add((Component)canvas3D);
        canvas3D.addKeyListener((KeyListener)this);
        this.addKeyListener(this);
        branchGroup.compile();
        locale.addBranchGraph(branchGroup);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            this.speed -= 10;
            this.rotationAlpha.setIncreasingAlphaDuration((long)this.speed);
        } else if (keyEvent.getKeyCode() == 40) {
            this.speed += 10;
            this.rotationAlpha.setIncreasingAlphaDuration((long)this.speed);
        } else if (keyEvent.getKeyCode() == 33) {
            this.speed -= 500;
            this.rotationAlpha.setIncreasingAlphaDuration((long)this.speed);
        } else if (keyEvent.getKeyCode() == 34) {
            this.speed += 500;
            this.rotationAlpha.setIncreasingAlphaDuration((long)this.speed);
        } else if (keyEvent.getKeyCode() == 80) {
            boolean bl = this.paused = !this.paused;
            if (this.paused) {
                this.rotationAlpha.setIncreasingAlphaDuration(0L);
            } else {
                this.rotationAlpha.setIncreasingAlphaDuration((long)this.speed);
            }
        } else if (keyEvent.getKeyCode() == 81) {
            Transform3D transform3D = new Transform3D();
            for (int i = 0; i < this.rotator.length; ++i) {
                if (i % 2 == 0) {
                    transform3D.rotX(1.5707963267948966);
                } else {
                    transform3D.rotX(-1.5707963267948966);
                }
                this.rotator[i].setTransformAxis(transform3D);
            }
        } else if (keyEvent.getKeyCode() == 87) {
            Transform3D transform3D = new Transform3D();
            for (int i = 0; i < this.rotator.length; ++i) {
                transform3D.rotX((double)i * Math.PI * 2.0 / (double)this.rotator.length);
                this.rotator[i].setTransformAxis(transform3D);
            }
        } else if (keyEvent.getKeyCode() == 69) {
            Transform3D transform3D = new Transform3D();
            for (int i = 0; i < this.rotator.length; ++i) {
                if (i < this.rotator.length / 2) {
                    transform3D.rotX((double)i * Math.PI * 2.0 / (double)this.rotator.length);
                } else {
                    transform3D.rotX((double)(-i) * Math.PI * 2.0 / (double)this.rotator.length);
                }
                this.rotator[i].setTransformAxis(transform3D);
            }
        } else if (keyEvent.getKeyCode() == 65) {
            Transform3D transform3D = new Transform3D();
            transform3D.rotX(1.5707963267948966);
            for (int i = 0; i < this.rotator.length; ++i) {
                this.rotator[i].setTransformAxis(transform3D);
            }
        } else if (keyEvent.getKeyCode() == 83) {
            Transform3D transform3D = new Transform3D();
            transform3D.rotY(1.5707963267948966);
            for (int i = 0; i < this.rotator.length; ++i) {
                this.rotator[i].setTransformAxis(transform3D);
            }
        } else if (keyEvent.getKeyCode() == 68) {
            Transform3D transform3D = new Transform3D();
            transform3D.rotZ(1.5707963267948966);
            for (int i = 0; i < this.rotator.length; ++i) {
                this.rotator[i].setTransformAxis(transform3D);
            }
        } else if (keyEvent.getKeyCode() == 90) {
            Transform3D transform3D = new Transform3D();
            for (int i = 0; i < this.rotator.length; ++i) {
                transform3D.setEuler(new Vector3d(Math.random() * Math.PI * 2.0, Math.random() * Math.PI * 2.0, Math.random() * Math.PI * 2.0));
                this.rotator[i].setTransformAxis(transform3D);
            }
        } else if (keyEvent.getKeyCode() == 88) {
            Transform3D transform3D = new Transform3D();
            for (int i = 0; i < this.rotator.length; ++i) {
                transform3D.setEuler(new Vector3d((double)i * Math.PI * 2.0 / (double)this.rotator.length, (double)i * Math.PI * 2.0 / (double)this.rotator.length, (double)i * Math.PI * 2.0 / (double)this.rotator.length));
                this.rotator[i].setTransformAxis(transform3D);
            }
        } else if (keyEvent.getKeyCode() == 67) {
            Transform3D transform3D = new Transform3D();
            for (int i = 0; i < this.rotator.length; ++i) {
                transform3D.rotZ((double)i * Math.PI * 2.0 / (double)this.rotator.length);
                this.rotator[i].setTransformAxis(transform3D);
            }
        } else if (keyEvent.getKeyCode() == 104) {
            Transform3D transform3D = new Transform3D();
            Transform3D transform3D2 = new Transform3D();
            this.offsetVector.x += 0.5;
            transform3D.setTranslation(this.offsetVector);
            for (int i = 0; i < this.offset.length; ++i) {
                this.initialPosition[i].getTransform(transform3D2);
                transform3D2.setTranslation(new Vector3d());
                transform3D2.mul(transform3D);
                this.initialPosition[i].setTransform(transform3D2);
                this.offset[i].setTransform(transform3D);
            }
        } else if (keyEvent.getKeyCode() == 98) {
            Transform3D transform3D = new Transform3D();
            Transform3D transform3D3 = new Transform3D();
            this.offsetVector.x -= 0.5;
            transform3D.setTranslation(this.offsetVector);
            for (int i = 0; i < this.offset.length; ++i) {
                this.initialPosition[i].getTransform(transform3D3);
                transform3D3.setTranslation(new Vector3d());
                transform3D3.mul(transform3D);
                this.initialPosition[i].setTransform(transform3D3);
                this.offset[i].setTransform(transform3D);
            }
        } else if (keyEvent.getKeyCode() == 102) {
            Transform3D transform3D = new Transform3D();
            Transform3D transform3D4 = new Transform3D();
            this.offsetVector.y += 0.5;
            transform3D.setTranslation(this.offsetVector);
            for (int i = 0; i < this.offset.length; ++i) {
                this.initialPosition[i].getTransform(transform3D4);
                transform3D4.setTranslation(new Vector3d());
                transform3D4.mul(transform3D);
                this.initialPosition[i].setTransform(transform3D4);
                this.offset[i].setTransform(transform3D);
            }
        } else if (keyEvent.getKeyCode() == 100) {
            Transform3D transform3D = new Transform3D();
            Transform3D transform3D5 = new Transform3D();
            this.offsetVector.y -= 0.5;
            transform3D.setTranslation(this.offsetVector);
            for (int i = 0; i < this.offset.length; ++i) {
                this.initialPosition[i].getTransform(transform3D5);
                transform3D5.setTranslation(new Vector3d());
                transform3D5.mul(transform3D);
                this.initialPosition[i].setTransform(transform3D5);
                this.offset[i].setTransform(transform3D);
            }
        } else if (keyEvent.getKeyCode() == 82) {
            if (this.index < 0) {
                this.index = 0;
                this.direction = 1;
            } else if (this.index >= this.cubeGroup.length) {
                this.index = this.cubeGroup.length - 1;
                this.direction = 2;
            }
            if (this.direction == 2) {
                this.holder.moveTo(this.cubeGroup[this.index]);
                --this.index;
            } else if (this.direction == 1) {
                this.offset[this.index].moveTo(this.cubeGroup[this.index]);
                ++this.index;
            }
            return;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public static void main(String[] stringArray) {
        float f = defaultLength;
        double d = defaultCenterOffset;
        int n = defaultNumSections;
        int n2 = defaultSpeed;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() > 2) {
                if (stringArray[i].toLowerCase().startsWith("-l")) {
                    try {
                        f = Float.parseFloat(stringArray[i].substring(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("\"" + stringArray[i].substring(2) + "\" is not a valid float.");
                        bl = true;
                    }
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("-o")) {
                    try {
                        d = Double.parseDouble(stringArray[i].substring(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("\"" + stringArray[i].substring(2) + "\" is not a valid double.");
                        bl = true;
                    }
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("-n")) {
                    try {
                        n = Integer.parseInt(stringArray[i].substring(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("\"" + stringArray[i].substring(2) + "\" is not a valid integer.");
                        bl = true;
                    }
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("-s")) {
                    try {
                        n2 = Integer.parseInt(stringArray[i].substring(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("\"" + stringArray[i].substring(2) + "\" is not a valid integer.");
                        bl = true;
                    }
                    continue;
                }
                System.err.println("Unknown option \"" + stringArray[i].substring(0, 2) + "\"");
                bl = true;
                continue;
            }
            if (stringArray[i].toLowerCase().startsWith("-h")) {
                bl = true;
                continue;
            }
            System.err.println("Unknown option \"" + stringArray[i] + "\"");
            bl = true;
        }
        if (bl) {
            System.out.println("Usage:");
            System.out.println("  DetachTest -l(float) -h(double) -n(integer) -s(integer) -h");
            System.out.println("   -l => length => Sets the size of the color cubes");
            System.out.println("   -o => offset => Sets rotation distance");
            System.out.println("   -n => number => Sets the number of cubes");
            System.out.println("   -s => speed => Sets the delay in milliseconds");
            System.out.println("   -h => help => Prints this message");
            System.out.println("");
            System.out.println(" Once the program is started pressing the up and down keys will");
            System.out.println("  increase the delay by 10 millisecond and pgup and pgdown will");
            System.out.println("  increase it by 500. Also the p key will toggle it between its");
            System.out.println("  current state and 0. Some setting like -n50 -o0 are pretty.");
            System.out.println("  (Well, if your machine can get better than .3fps.) =)");
            System.out.println("");
            System.out.println(" The purpose of this program is to illustrate some bugs in the java");
            System.out.println("  3d libraries. Whenever the r key is pressed one of the cubes will");
            System.out.println("  be removed from the scene graph and attached to a group not in the");
            System.out.println("  scene using the Group.moveTo(BranchGroup) method. In the 1.1");
            System.out.println("  implementation the cubes do not disappear when removed, or at least");
            System.out.println("  not until they are begun to be put back in. In the 1.2 implementation");
            System.out.println("  they disappear, but if you add and remove them too quickly you get");
            System.out.println("  a null pointer exception and rendering stops.");
        } else {
            new MainFrame((Applet)new DetachTest(f, d, n, n2), 400, 300);
        }
    }
}

