/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.ui;

import java.awt.BasicStroke;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.himinbi.ui.DashPanel;
import org.himinbi.ui.StrokePropertiesPanel;
import org.himinbi.ui.StrokeViewPanel;

public class StrokeOptionsPanel
extends JPanel
implements ActionListener {
    StrokePropertiesPanel strokeProperties = new StrokePropertiesPanel();
    DashPanel dashProperties = new DashPanel();
    StrokeViewPanel strokeView = new StrokeViewPanel();

    public StrokeOptionsPanel() {
        this(new BasicStroke());
    }

    public StrokeOptionsPanel(Stroke stroke) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("Properties", this.strokeProperties);
        jTabbedPane.add("Dashes", this.dashProperties);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jTabbedPane, gridBagConstraints);
        this.add(jTabbedPane);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.strokeView, gridBagConstraints);
        this.add(this.strokeView);
        this.strokeProperties.addActionListener(this);
        this.dashProperties.addActionListener(this);
        this.setStroke(stroke);
    }

    public Stroke getStroke() {
        return new BasicStroke(this.dashProperties.getLineWidth(), this.strokeProperties.getCapType(), this.strokeProperties.getJoinType(), this.strokeProperties.getMiterLimit(), this.dashProperties.getDashes(), this.dashProperties.getDashOffset());
    }

    public void setStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            this.strokeProperties.setCapType(basicStroke.getEndCap());
            this.strokeProperties.setJoinType(basicStroke.getLineJoin());
            this.strokeProperties.setMiterLimit(basicStroke.getMiterLimit());
            this.dashProperties.setDashes(basicStroke.getDashArray());
            this.dashProperties.setDashOffset(basicStroke.getDashPhase());
            this.dashProperties.setLineWidth(basicStroke.getLineWidth());
            this.strokeView.setStroke(stroke);
        } else {
            JOptionPane.showMessageDialog(this, "Stroke type: " + stroke.getClass().getName() + " is not implemented", "Stroke Creation Error", 0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.strokeView.setStroke(this.getStroke());
    }
}

