/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.ui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.himinbi.ui.GradientOptionsPanel;
import org.himinbi.ui.TypeSelectionPanel;
import org.himinbi.ui.TypedComponent;

public class PaintOptionsPanel
extends JPanel
implements TypedComponent,
ActionListener {
    String paintType;
    boolean typeChanged = false;
    boolean colorChanged = false;
    Paint paint;
    JButton solidColor = new JButton();
    GradientOptionsPanel gradientOptions;
    TypeSelectionPanel typeSelectionPanel;
    JPanel optionsPanel;
    CardLayout optionsLayout;
    Dimension bounds = new Dimension(300, 300);

    public PaintOptionsPanel() {
        this(new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
    }

    public PaintOptionsPanel(Paint paint) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        String[] stringArray = new String[]{"None", "Solid", "Gradient", "Texture"};
        this.typeSelectionPanel = new TypeSelectionPanel("Paint Type:", stringArray, this);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.typeSelectionPanel, gridBagConstraints);
        this.add(this.typeSelectionPanel);
        this.optionsPanel = new JPanel();
        this.optionsLayout = new CardLayout();
        this.optionsPanel.setLayout(this.optionsLayout);
        this.optionsPanel.add("None", new JPanel());
        this.solidColor.addActionListener(this);
        this.optionsPanel.add("Solid", this.solidColor);
        this.gradientOptions = new GradientOptionsPanel();
        this.gradientOptions.addActionListener(this);
        this.optionsPanel.add("Gradient", this.gradientOptions);
        JLabel jLabel = new JLabel("Not Implemented", 0);
        this.optionsPanel.add("Texture", jLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.optionsPanel, gridBagConstraints);
        this.add(this.optionsPanel);
        this.setPaint(paint);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
        Color color = JColorChooser.showDialog(abstractButton, abstractButton.getText(), abstractButton.getBackground());
        if (color != null) {
            abstractButton.setBackground(color);
            this.colorChanged = true;
        }
    }

    public Paint getPaint() {
        if (this.typeChanged || this.colorChanged) {
            if (this.paintType == "None") {
                this.paint = null;
            } else if (this.paintType == "Solid") {
                this.paint = this.solidColor.getBackground();
            } else if (this.paintType == "Gradient") {
                this.paint = new GradientPaint(0.0f, 0.0f, this.gradientOptions.getColor(0), 1.0f, 1.0f, this.gradientOptions.getColor(1));
            } else {
                JOptionPane.showMessageDialog(this, "Paint type: " + this.paintType + " is not implemented", "Paint Creation Error", 0);
                this.paint = null;
            }
        }
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
        if (paint == null) {
            this.setType("None");
        } else if (paint instanceof Color) {
            this.solidColor.setBackground((Color)paint);
            this.setType("Solid");
        } else if (paint instanceof GradientPaint) {
            this.gradientOptions.setColor(0, ((GradientPaint)paint).getColor1());
            this.gradientOptions.setColor(1, ((GradientPaint)paint).getColor2());
            this.setType("Gradient");
        } else {
            JOptionPane.showMessageDialog(this, "Paint type: " + paint.getClass().getName() + " is not implemented", "Paint Creation Error", 0);
            paint = null;
            this.setType("None");
        }
    }

    public String getType() {
        return this.paintType;
    }

    public void setType(String string) {
        if (this.paintType != string) {
            this.optionsLayout.show(this.optionsPanel, string);
            this.paintType = string;
            this.typeChanged = true;
            this.typeSelectionPanel.setType(string);
        }
    }
}

