/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.ui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ProgressMonitor;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.himinbi.util.ConfigurableFileFilter;

public class ImageDisplayPanel
extends JPanel
implements ActionListener {
    EventListenerList listeners = new EventListenerList();
    String currentKey;
    Hashtable images = new Hashtable();
    ButtonGroup buttonGroup = new ButtonGroup();
    GridLayout layout = new GridLayout(1, 1, 0, 0);
    ConfigurableFileFilter fileFilter;
    JFileChooser chooser = new JFileChooser();
    MediaTracker tracker = new MediaTracker(this);
    int iconWidth = 200;
    int maxIconHeight = 200;
    double columnRatio = 2.0;

    public ImageDisplayPanel() {
        this.setLayout(this.layout);
        String[] stringArray = new String[]{"png", "jpg,jpeg", "gif"};
        String[] stringArray2 = new String[]{"Portable Net Graphics", "Joint Photographic Experts Group", "Graphics Interchange Format"};
        this.chooser.setFileSelectionMode(2);
        this.chooser.setMultiSelectionEnabled(true);
        this.fileFilter = new ConfigurableFileFilter(stringArray, stringArray2, "Image Files");
        this.chooser.addChoosableFileFilter((FileFilter)this.fileFilter);
        ConfigurableFileFilter[] configurableFileFilterArray = this.fileFilter.getSubFilters();
        for (int i = 0; i < configurableFileFilterArray.length; ++i) {
            this.chooser.addChoosableFileFilter((FileFilter)configurableFileFilterArray[i]);
        }
        this.chooser.setFileFilter((FileFilter)this.fileFilter);
    }

    public void setImageDirectory(File file) {
        this.setImageDirectory(file, false);
    }

    public void setImageDirectory(File file, boolean bl) {
        File[] fileArray = FileSystemView.getFileSystemView().getFiles(file, true);
        Vector<URL> vector = new Vector<URL>();
        boolean bl2 = false;
        for (int i = 0; i < fileArray.length; ++i) {
            if (!this.fileFilter.accept(fileArray[i]) || fileArray[i].isDirectory()) continue;
            try {
                vector.add(fileArray[i].toURL());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.setFiles(vector, bl);
    }

    public void setFiles(Vector vector) {
        this.setFiles(vector, false);
    }

    public void setFiles(Vector vector, boolean bl) {
        ProgressMonitor progressMonitor = new ProgressMonitor(this, "Loading Images", "", 0, vector.size());
        progressMonitor.setMillisToDecideToPopup(0);
        for (int i = 0; i < vector.size() && !progressMonitor.isCanceled(); ++i) {
            URL uRL = (URL)vector.get(i);
            progressMonitor.setNote("Loading: " + uRL);
            System.out.println("Loading: " + uRL);
            this.addFile(uRL, bl);
            progressMonitor.setProgress(i + 1);
            if (!bl) continue;
            bl = false;
        }
    }

    public void addFile(URL uRL) {
        this.addFile(uRL, false);
    }

    public void addFile(URL uRL, boolean bl) {
        if (bl) {
            this.images.clear();
        }
        if (uRL != null) {
            System.out.println("Trying to load: " + uRL);
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            this.tracker.addImage(image, 0);
            try {
                this.tracker.waitForID(0, 5000L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Error: " + uRL + " interrupted while loading");
            }
            this.tracker.removeImage(image, 0);
            System.out.println("Size: <" + image.getWidth(this) + ", " + image.getHeight(this) + ">");
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(this), image.getHeight(this), 1);
            bufferedImage.createGraphics().drawImage(image, 0, 0, Color.white, this);
            String string = uRL.toString();
            this.images.put(string, bufferedImage);
            this.addButton(string);
            this.setKey(string);
        }
        this.resetLayout();
    }

    protected void addButton(String string) {
        BufferedImage bufferedImage = (BufferedImage)this.images.get(string);
        double d = Math.min((double)this.iconWidth / (double)bufferedImage.getWidth(), (double)this.maxIconHeight / (double)bufferedImage.getHeight());
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(d, d), 1);
        JRadioButton jRadioButton = new JRadioButton(new ImageIcon(affineTransformOp.filter(bufferedImage, null), string));
        jRadioButton.setBorderPainted(true);
        jRadioButton.setToolTipText(string);
        jRadioButton.addActionListener(this);
        jRadioButton.setActionCommand(string);
        this.buttonGroup.add(jRadioButton);
        this.add(jRadioButton);
    }

    protected void resetLayout() {
        this.layout.setColumns(Math.max((int)Math.ceil(Math.sqrt(this.images.size())), 1));
        this.layout.setRows(Math.max((int)Math.ceil(Math.sqrt(this.images.size())), 1));
        System.out.println("Setting layout to: [" + this.layout.getColumns() + ", " + this.layout.getRows() + "]");
        this.revalidate();
    }

    protected void redraw() {
        this.resetLayout();
        this.removeAll();
        Enumeration enumeration = this.images.keys();
        while (enumeration.hasMoreElements()) {
            this.addButton((String)enumeration.nextElement());
        }
    }

    public void chooseFiles() {
        if (this.chooser.showDialog(this, null) == 0) {
            File[] fileArray = this.chooser.getSelectedFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.setImageDirectory(fileArray[i]);
                    continue;
                }
                try {
                    this.addFile(fileArray[i].toURL());
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
    }

    public BufferedImage getImage() {
        return this.getImage(this.currentKey);
    }

    public BufferedImage getImage(String string) {
        return (BufferedImage)this.images.get(string);
    }

    public String getKey() {
        return this.currentKey;
    }

    public void setKey(String string) {
        String string2 = this.currentKey;
        this.currentKey = string;
        this.firePropertyChange(new PropertyChangeEvent(this, "key", string2, this.currentKey));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setKey(actionEvent.getActionCommand());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(PropertyChangeListener.class, propertyChangeListener);
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0 && propertyChangeEvent != null; i -= 2) {
            if (objectArray[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }
}

