/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.himinbi.ui.PointRatio;

class GradientPointsPanel
extends JPanel
implements PropertyChangeListener {
    int internalSize = 3;
    int externalSize = 15;
    Object antialiasHint = RenderingHints.VALUE_ANTIALIAS_ON;
    Color[] paint = new Color[]{Color.black, Color.yellow, Color.red};
    static final int NORMAL = 0;
    static final int HOVER = 1;
    static final int SELECTED = 2;
    int[] state = new int[]{0, 0};
    Point2D.Float[] point = new Point2D.Float[]{new Point2D.Float(), new Point2D.Float()};
    PointRatio[] ratio = new PointRatio[]{new PointRatio(0.25f, 0.25f), new PointRatio(0.75f, 0.75f)};
    Component[] colorComponent = new Component[2];
    Stroke stroke = new BasicStroke(3.0f);

    GradientPointsPanel() {
        this.setBorder(BorderFactory.createEtchedBorder(0));
        this.setPreferredSize(new Dimension(75, 75));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                boolean bl = false;
                for (int i = 0; i < GradientPointsPanel.this.point.length; ++i) {
                    if (Math.abs(GradientPointsPanel.this.point[i].x - (float)point.x) <= (float)GradientPointsPanel.this.externalSize && Math.abs(GradientPointsPanel.this.point[i].y - (float)point.y) <= (float)GradientPointsPanel.this.externalSize) {
                        if (GradientPointsPanel.this.state[i] != 0) continue;
                        GradientPointsPanel.this.state[i] = 1;
                        bl = true;
                        continue;
                    }
                    if (GradientPointsPanel.this.state[i] == 0) continue;
                    GradientPointsPanel.this.state[i] = 0;
                    bl = true;
                }
                if (bl) {
                    GradientPointsPanel.this.repaint();
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                boolean bl = false;
                for (int i = 0; i < GradientPointsPanel.this.point.length; ++i) {
                    if (GradientPointsPanel.this.state[i] != 2) continue;
                    GradientPointsPanel.this.ratio[i].x = (float)point.x / (float)GradientPointsPanel.this.getWidth();
                    GradientPointsPanel.this.ratio[i].y = (float)point.y / (float)GradientPointsPanel.this.getHeight();
                    bl = true;
                }
                if (bl) {
                    GradientPointsPanel.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                boolean bl = this.transitionState(1, 2, 1);
                if (bl) {
                    this.transitionState(1, 0, -1);
                    GradientPointsPanel.this.repaint();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                boolean bl = this.transitionState(2, 1, -1);
                if (bl) {
                    GradientPointsPanel.this.repaint();
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                boolean bl = this.transitionState(1, 0, -1);
                if (bl) {
                    GradientPointsPanel.this.repaint();
                }
            }

            private boolean transitionState(int n, int n2, int n3) {
                boolean bl = false;
                for (int i = 0; i < GradientPointsPanel.this.point.length && n3 != 0; ++i) {
                    if (GradientPointsPanel.this.state[i] != n) continue;
                    GradientPointsPanel.this.state[i] = n2;
                    --n3;
                    bl = true;
                }
                return bl;
            }
        });
    }

    private void updatePoints() {
        for (int i = 0; i < this.point.length; ++i) {
            this.point[i].x = this.ratio[i].x * (float)this.getWidth();
            this.point[i].y = this.ratio[i].y * (float)this.getHeight();
        }
    }

    public void paintComponent(Graphics graphics) {
        this.updatePoints();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(new GradientPaint(this.point[0], this.colorComponent[0].getBackground(), this.point[1], this.colorComponent[1].getBackground()));
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasHint);
        graphics2D.setStroke(this.stroke);
        for (int i = 0; i < this.point.length; ++i) {
            graphics2D.setPaint(this.paint[this.state[i]]);
            graphics2D.fillOval((int)(this.point[i].x - (float)(this.internalSize / 2)), (int)(this.point[i].y - (float)(this.internalSize / 2)), this.internalSize + 1, this.internalSize + 1);
            graphics2D.drawOval((int)(this.point[i].x - (float)(this.externalSize / 2)), (int)(this.point[i].y - (float)(this.externalSize / 2)), this.externalSize, this.externalSize);
        }
    }

    public void setColorComponent(int n, JComponent jComponent) {
        jComponent.addPropertyChangeListener(this);
        this.colorComponent[n] = jComponent;
        this.repaint();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("background")) {
            this.repaint();
        }
    }
}

