/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.j3d.test;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.Background;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.himinbi.j3d.test.JTuple3dField;
import org.himinbi.j3d.test.ViewPlatformTestSettings;

class ViewPlatformTestSettingsPanel
extends JPanel
implements ViewPlatformTestSettings {
    public static final int SINGLE = 1;
    public static final int numProperties = 13;
    public static final int NONE = -1;
    public static final int NUM_SPHERES = 0;
    public static final int NUM_SPIRALS = 1;
    public static final int NUM_CAMERAS = 2;
    public static final int CAMERA_POSITION = 3;
    public static final int SPHERE_OFFSET = 4;
    public static final int AMBIENT_COLOR = 5;
    public static final int DIFFUSE_COLOR = 6;
    public static final int SATURATION = 7;
    public static final int SHININESS = 8;
    public static final int RADIUS = 9;
    public static final int BACKGROUND = 10;
    public static final int LIGHT_COLOR = 11;
    public static final int LIGHT_DIRECTION = 12;
    Object[] value = new Object[13];
    Object[] control = new Object[13];
    boolean[] dirty = new boolean[13];

    public ViewPlatformTestSettingsPanel(int n, int n2, int n3, Point3d point3d, Vector3d vector3d, Color color, Color color2, float f, float f2, float f3, Color color3, Color color4, Vector3f vector3f) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.addComponent(-1, gridBagLayout, 1, gridBagConstraints, new JLabel("Spheres:"));
        this.addComponent(-1, gridBagLayout, -1, gridBagConstraints, new JLabel("Spirals:"));
        this.addComponent(-1, gridBagLayout, 0, gridBagConstraints, new JLabel("Cameras:"));
        this.addComponent(0, gridBagLayout, 1, gridBagConstraints, new JTextField(String.valueOf(n)));
        this.addComponent(1, gridBagLayout, -1, gridBagConstraints, new JTextField(String.valueOf(n2)));
        this.addComponent(2, gridBagLayout, 0, gridBagConstraints, new JTextField(String.valueOf(n3)));
        this.addComponent(-1, gridBagLayout, 1, gridBagConstraints, new JLabel("Camera Position:"));
        this.addComponent(3, gridBagLayout, 0, gridBagConstraints, (Component)new JTuple3dField((Tuple3d)point3d));
        this.addComponent(-1, gridBagLayout, 1, gridBagConstraints, new JLabel("Sphere Offset:"));
        this.addComponent(4, gridBagLayout, 0, gridBagConstraints, (Component)new JTuple3dField((Tuple3d)vector3d));
        this.addComponent(-1, gridBagLayout, 1, gridBagConstraints, new JLabel("Saturation:"));
        this.addComponent(-1, gridBagLayout, -1, gridBagConstraints, new JLabel("Shininess:"));
        this.addComponent(-1, gridBagLayout, 0, gridBagConstraints, new JLabel("Radius:"));
        this.addComponent(7, gridBagLayout, 1, gridBagConstraints, new JTextField(String.valueOf(f)));
        this.addComponent(8, gridBagLayout, -1, gridBagConstraints, new JTextField(String.valueOf(f2)));
        this.addComponent(9, gridBagLayout, 0, gridBagConstraints, new JTextField(String.valueOf(f3)));
        this.addComponent(-1, gridBagLayout, 1, gridBagConstraints, new JLabel("Ambient Color:"));
        this.addComponent(-1, gridBagLayout, -1, gridBagConstraints, new JLabel("Diffuse Color:"));
        this.addComponent(-1, gridBagLayout, 0, gridBagConstraints, new JLabel("Background Color:"));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        class ColorButton
        extends JButton {
            public ColorButton(Color color) {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.changeColor();
                    }
                });
                this.setBackground(color);
            }

            public void changeColor() {
                Color color = JColorChooser.showDialog(this, "Choose Color", this.getBackground());
                if (color != null) {
                    this.setBackground(color);
                }
            }
        }
        this.addComponent(5, gridBagLayout, 1, gridBagConstraints, new ColorButton(color));
        this.addComponent(6, gridBagLayout, -1, gridBagConstraints, new ColorButton(color2));
        this.addComponent(10, gridBagLayout, 0, gridBagConstraints, new ColorButton(color3));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        this.addComponent(-1, gridBagLayout, 1, gridBagConstraints, new JLabel("Light Color:"));
        this.addComponent(-1, gridBagLayout, 0, gridBagConstraints, new JLabel("Light Direction:"));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.addComponent(11, gridBagLayout, 1, gridBagConstraints, new ColorButton(color4));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        this.addComponent(12, gridBagLayout, 0, gridBagConstraints, (Component)new JTuple3dField((Tuple3f)vector3f));
        for (int i = this.dirty.length - 1; i >= 0; --i) {
            this.dirty[i] = true;
        }
    }

    private void addComponent(int n, GridBagLayout gridBagLayout, int n2, GridBagConstraints gridBagConstraints, Component component) {
        if (n != -1) {
            this.control[n] = component;
        }
        gridBagConstraints.gridwidth = n2;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public int getNumSpheres() {
        return ((Number)this.getProperty(0)).intValue();
    }

    public int getNumSpirals() {
        return ((Number)this.getProperty(1)).intValue();
    }

    public int getNumCameras() {
        return ((Number)this.getProperty(2)).intValue();
    }

    public Point3d getCameraPosition() {
        return (Point3d)this.getProperty(3);
    }

    public Vector3d getSphereOffset() {
        return (Vector3d)this.getProperty(4);
    }

    public Color3f getAmbientColor() {
        return (Color3f)this.getProperty(5);
    }

    public Color3f getDiffuseColor() {
        return (Color3f)this.getProperty(6);
    }

    public float getSaturation() {
        return ((Number)this.getProperty(7)).floatValue();
    }

    public float getShininess() {
        return ((Number)this.getProperty(8)).floatValue();
    }

    public float getRadius() {
        return ((Number)this.getProperty(9)).floatValue();
    }

    public Background getSceneBackground() {
        return (Background)this.getProperty(10);
    }

    public Color3f getLightColor() {
        return (Color3f)this.getProperty(11);
    }

    public Vector3f getLightDirection() {
        return (Vector3f)this.getProperty(12);
    }

    public Object getProperty(int n) {
        if (this.dirty[n]) {
            this.clean(n);
        }
        return this.value[n];
    }

    protected void clean(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.value[n] = Integer.valueOf(((JTextField)this.control[n]).getText());
                break;
            }
            case 3: {
                this.value[n] = new Point3d(((JTuple3dField)this.control[n]).getValue());
                break;
            }
            case 12: {
                this.value[n] = new Vector3f(((JTuple3dField)this.control[n]).getValue());
                break;
            }
            case 4: {
                this.value[n] = new Vector3d(((JTuple3dField)this.control[n]).getValue());
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                this.value[n] = new Color3f(((JButton)this.control[n]).getBackground());
                break;
            }
            case 10: {
                this.value[n] = new Background(new Color3f(((JButton)this.control[n]).getBackground()));
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                this.value[n] = Float.valueOf(((JTextField)this.control[n]).getText());
                break;
            }
            default: {
                System.err.println("Property index not matched, " + n + "; " + "proerty not cleaned");
            }
        }
        this.dirty[n] = false;
    }
}

