/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.j3d.test;

import com.miltec.mvis.Axes;
import com.miltec.mvis.MouseSphereRotate;
import com.miltec.mvis.SimpleScene;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.himinbi.j3d.test.Matrix4dPanel;
import org.himinbi.j3d.test.Vector3dPanel;

public class BehaviorTest
extends JApplet
implements ActionListener,
MouseBehaviorCallback {
    Vector3dPanel vectorPanel;
    JButton vectorButton = new JButton("Compute");
    Matrix4dPanel matrixPanel;
    JButton matrixButton = new JButton("Compute");
    TransformGroup axesTransformation;
    JTextField scaleField = new JTextField("0");
    JButton scaleButton = new JButton("Compute");
    JButton resetButton = new JButton("Reset");
    JCheckBox visibleBox;
    SimpleScene scene;

    public BehaviorTest() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.fill = 1;
        Canvas3D canvas3D = this.createCanvas();
        gridBagLayout.setConstraints((Component)canvas3D, gridBagConstraints);
        this.getContentPane().add((Component)canvas3D);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        this.matrixPanel = new Matrix4dPanel(new Matrix4d());
        gridBagLayout.setConstraints(this.matrixPanel, gridBagConstraints);
        this.getContentPane().add(this.matrixPanel);
        gridBagLayout.setConstraints(this.matrixButton, gridBagConstraints);
        this.getContentPane().add(this.matrixButton);
        this.matrixButton.addActionListener(this);
        this.vectorPanel = new Vector3dPanel(new Vector3d());
        gridBagLayout.setConstraints(this.vectorPanel, gridBagConstraints);
        this.getContentPane().add(this.vectorPanel);
        gridBagLayout.setConstraints(this.vectorButton, gridBagConstraints);
        this.getContentPane().add(this.vectorButton);
        this.vectorButton.addActionListener(this);
        JLabel jLabel = new JLabel("Scale:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.getContentPane().add(jLabel);
        gridBagConstraints.insets.left = 5;
        this.scaleField.addActionListener(this);
        gridBagLayout.setConstraints(this.scaleField, gridBagConstraints);
        this.getContentPane().add(this.scaleField);
        gridBagConstraints.insets.left = 0;
        this.scaleButton.addActionListener(this);
        gridBagLayout.setConstraints(this.scaleButton, gridBagConstraints);
        this.getContentPane().add(this.scaleButton);
        this.resetButton.addActionListener(this);
        gridBagLayout.setConstraints(this.resetButton, gridBagConstraints);
        this.getContentPane().add(this.resetButton);
    }

    private Canvas3D createCanvas() {
        float f = 1.0f;
        float f2 = 0.05f;
        View view = new View();
        view.setPhysicalBody(new PhysicalBody());
        view.setPhysicalEnvironment(new PhysicalEnvironment());
        view.setBackClipDistance(5000.0);
        Canvas3D canvas3D = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        view.addCanvas3D(canvas3D);
        ViewPlatform viewPlatform = new ViewPlatform();
        view.attachViewPlatform(viewPlatform);
        this.scene = new SimpleScene((Component)canvas3D, f);
        new Axes((Group)this.scene.getRoot(), f2, f);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(0.0f, 0.0f, f));
        this.scene.getRoot().setTransform(transform3D);
        this.scene.getRoot().setCapability(17);
        this.scene.getRoot().setCapability(18);
        MouseSphereRotate mouseSphereRotate = new MouseSphereRotate(this.scene.getRoot());
        mouseSphereRotate.setSchedulingBounds((Bounds)boundingSphere);
        mouseSphereRotate.setupCallback(this);
        this.scene.getRoot().addChild((Node)mouseSphereRotate);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.setTranslation(new Vector3f(0.0f, f / 5.0f, f * 5.0f));
        TransformGroup transformGroup = new TransformGroup(transform3D2);
        transformGroup.addChild((Node)viewPlatform);
        this.scene.getHead().addChild((Node)transformGroup);
        this.scene.makeLive();
        return canvas3D;
    }

    public void transformChanged(int n, Transform3D transform3D) {
        Matrix4d matrix4d = new Matrix4d();
        transform3D.get(matrix4d);
        this.matrixPanel.setMatrix(matrix4d);
        this.scaleField.setText(Double.toString(transform3D.getScale()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Transform3D transform3D = new Transform3D();
        if (actionEvent.getSource() == this.vectorButton) {
            transform3D.setEuler(this.vectorPanel.getVector());
        } else if (actionEvent.getSource() == this.matrixButton) {
            transform3D.set(this.matrixPanel.getMatrix());
        } else if (actionEvent.getSource() == this.scaleButton) {
            try {
                transform3D.setScale(Double.parseDouble(this.scaleField.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                this.scaleField.setText("0");
                return;
            }
        } else if (actionEvent.getSource() == this.resetButton) {
            this.vectorPanel.setVector(new Vector3d());
        }
        try {
            this.scene.getRoot().setTransform(transform3D);
            this.transformChanged(0, transform3D);
        }
        catch (BadTransformException badTransformException) {
            JOptionPane.showMessageDialog(null, "Non-affine transform");
        }
    }

    public static void main(String[] stringArray) {
        new MainFrame((Applet)new BehaviorTest(), 400, 300);
    }
}

