/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.j3d;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Component;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

public class SimpleScene {
    BranchGroup head;
    TransformGroup platformRotation;
    TransformGroup sceneRoot;
    static final float defaultEarthRadius = 6378.137f;
    float earthRadius = 100.0f;
    Locale locale;

    public SimpleScene(Component component) {
        this(component, 6378.137f);
    }

    public SimpleScene(Component component, float f) {
        Appearance appearance;
        VirtualUniverse virtualUniverse = new VirtualUniverse();
        this.locale = new Locale(virtualUniverse);
        this.head = new BranchGroup();
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
        Background background = new Background(new Color3f(0.11372549f, 0.16862746f, 0.6f));
        background.setApplicationBounds((Bounds)boundingSphere);
        this.head.addChild((Node)background);
        DirectionalLight directionalLight = new DirectionalLight(new Color3f(0.39215687f, 0.39215687f, 0.39215687f), new Vector3f(0.0f, 0.0f, -1.0f));
        directionalLight.setInfluencingBounds((Bounds)boundingSphere);
        this.head.addChild((Node)directionalLight);
        if (f > 0.0f) {
            appearance = new Appearance();
            String string = "images/earth_cl.jpg";
            TextureLoader textureLoader = new TextureLoader(string, "RGB", component);
            if (textureLoader != null && textureLoader.getTexture() != null) {
                appearance.setTexture(textureLoader.getTexture());
            } else {
                System.out.println("No texture loaded from \"" + string + "\"");
            }
            this.head.addChild((Node)new Sphere(f, 3, 180, appearance));
        } else {
            f = 0.0f;
        }
        appearance = new Transform3D();
        this.platformRotation = new TransformGroup((Transform3D)appearance);
        this.platformRotation.setCapability(17);
        this.platformRotation.setCapability(18);
        this.head.addChild((Node)this.platformRotation);
        appearance = new Transform3D();
        appearance.setTranslation(new Vector3f(0.0f, 0.0f, f));
        this.sceneRoot = new TransformGroup((Transform3D)appearance);
        this.sceneRoot.setCapability(12);
        this.sceneRoot.setCapability(13);
        this.sceneRoot.setCapability(14);
        this.platformRotation.addChild((Node)this.sceneRoot);
        this.earthRadius = f;
    }

    public void makeLive() {
        this.locale.addBranchGraph(this.head);
    }

    public TransformGroup getRoot() {
        return this.sceneRoot;
    }

    public TransformGroup getPlatformRotation() {
        return this.platformRotation;
    }

    public BranchGroup getHead() {
        return this.head;
    }

    public float getEarthRadius() {
        return this.earthRadius;
    }
}

