/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.j3d;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class MouseSphereRotate
extends MouseBehavior {
    double x_factor = -0.01;
    double y_factor = -0.01;
    int max_factor = 500;
    NumberFormat format = new DecimalFormat("###.000");
    private MouseBehaviorCallback callback = null;

    public MouseSphereRotate(TransformGroup transformGroup) {
        super(transformGroup);
    }

    public MouseSphereRotate() {
        this(0);
    }

    public MouseSphereRotate(int n) {
        super(n);
    }

    public void initialize() {
        super.initialize();
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.x_factor *= -1.0;
            this.y_factor *= -1.0;
        }
    }

    public double getXFactor() {
        return this.x_factor;
    }

    public double getYFactor() {
        return this.y_factor;
    }

    public void setXFactor(double d) {
        this.x_factor = d;
    }

    public void setYFactor(double d) {
        this.y_factor = d;
    }

    public void setFactor(double d) {
        this.x_factor = this.y_factor = d;
    }

    public void processStimulus(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            WakeupCriterion wakeupCriterion = (WakeupCriterion)enumeration.nextElement();
            if (!(wakeupCriterion instanceof WakeupOnAWTEvent)) continue;
            AWTEvent[] aWTEventArray = ((WakeupOnAWTEvent)wakeupCriterion).getAWTEvent();
            for (int i = 0; i < aWTEventArray.length; ++i) {
                this.processMouseEvent((MouseEvent)aWTEventArray[i]);
                if ((!this.buttonPress || (this.flags & 1) != 0) && (!this.wakeUp || (this.flags & 1) == 0)) continue;
                int n = aWTEventArray[i].getID();
                if (n == 506) {
                    if (!(this.reset || ((MouseEvent)aWTEventArray[i]).isMetaDown() || ((MouseEvent)aWTEventArray[i]).isAltDown())) {
                        this.x = ((MouseEvent)aWTEventArray[i]).getX();
                        this.y = ((MouseEvent)aWTEventArray[i]).getY();
                        this.transformGroup.getTransform(this.currXform);
                        boolean bl = true;
                        Vector3d vector3d = new Vector3d();
                        Matrix3d matrix3d = new Matrix3d();
                        this.currXform.get(vector3d);
                        double d = (double)(this.x - this.x_last) * this.x_factor;
                        double d2 = (double)(this.y - this.y_last) * this.y_factor;
                        if (Math.abs(d) > Math.abs(this.x_factor * (double)this.max_factor)) {
                            d = this.x_factor;
                        }
                        if (Math.abs(d2) > Math.abs(this.y_factor * (double)this.max_factor)) {
                            d2 = this.y_factor;
                        }
                        double d3 = vector3d.length();
                        if (((MouseEvent)aWTEventArray[i]).isAltDown()) {
                            vector3d.x *= 1.0 + d2 / d3;
                            vector3d.y *= 1.0 + d2 / d3;
                            vector3d.z *= 1.0 + d2 / d3;
                        } else {
                            double[] dArray;
                            if (d3 == 0.0) {
                                this.currXform.get(matrix3d);
                                vector3d.x = matrix3d.m02;
                                vector3d.y = matrix3d.m12;
                                vector3d.z = matrix3d.m22;
                                d3 = vector3d.length();
                                bl = false;
                            }
                            if ((dArray = new double[]{Math.sqrt(vector3d.x * vector3d.x + vector3d.z * vector3d.z), dArray[0] * Math.cos(d2) - vector3d.y * Math.sin(d2)})[0] * dArray[1] < 0.0) {
                                this.y_factor *= -1.0;
                            }
                            Vector3d vector3d2 = new Vector3d(vector3d.x * dArray[1] / dArray[0], dArray[0] * Math.sin(d2) + vector3d.y * Math.cos(d2), vector3d.z * dArray[1] / dArray[0]);
                            vector3d.x = vector3d2.x * Math.cos(d) - vector3d2.z * Math.sin(d);
                            vector3d.y = vector3d2.y;
                            vector3d.z = vector3d2.x * Math.sin(d) + vector3d2.z * Math.cos(d);
                            double d4 = vector3d.length();
                            vector3d.x = vector3d.x * d3 / d4;
                            vector3d.y = vector3d.y * d3 / d4;
                            vector3d.z = vector3d.z * d3 / d4;
                        }
                        matrix3d.m02 = vector3d.x / d3;
                        matrix3d.m12 = vector3d.y / d3;
                        matrix3d.m22 = vector3d.z / d3;
                        matrix3d.m00 = -1.0 / Math.sqrt(Math.pow(vector3d.x / vector3d.z, 2.0) + 1.0);
                        matrix3d.m10 = 0.0;
                        matrix3d.m20 = 1.0 / Math.sqrt(Math.pow(vector3d.z / vector3d.x, 2.0) + 1.0);
                        if (vector3d.x * vector3d.z <= 0.0) {
                            matrix3d.m20 *= -1.0;
                        }
                        if (vector3d.z >= 0.0) {
                            matrix3d.m00 *= -1.0;
                            matrix3d.m10 *= -1.0;
                            matrix3d.m20 *= -1.0;
                        }
                        matrix3d.m01 = matrix3d.m12 * matrix3d.m20 - matrix3d.m22 * matrix3d.m10;
                        matrix3d.m11 = matrix3d.m22 * matrix3d.m00 - matrix3d.m02 * matrix3d.m20;
                        matrix3d.m21 = matrix3d.m02 * matrix3d.m10 - matrix3d.m12 * matrix3d.m00;
                        this.currXform.set(matrix3d);
                        if (bl) {
                            this.currXform.setTranslation(vector3d);
                        }
                        this.transformGroup.setTransform(this.currXform);
                        this.transformChanged(this.currXform);
                        if (this.callback != null) {
                            this.callback.transformChanged(0, this.currXform);
                        }
                    } else {
                        this.reset = false;
                    }
                    this.x_last = this.x;
                    this.y_last = this.y;
                    continue;
                }
                if (n != 501) continue;
                this.x_last = ((MouseEvent)aWTEventArray[i]).getX();
                this.y_last = ((MouseEvent)aWTEventArray[i]).getY();
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    public void transformChanged(Transform3D transform3D) {
    }

    public void setupCallback(MouseBehaviorCallback mouseBehaviorCallback) {
        this.callback = mouseBehaviorCallback;
    }
}

