/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.j3d;

import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import javax.media.j3d.Appearance;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

public class Axes {
    static float defaultLength = 1.0f;
    static float defaultRadius = 0.01f;
    public static Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    public static Color3f white = new Color3f(0.78431374f, 0.78431374f, 0.78431374f);
    public static Color3f red = new Color3f(0.9882353f, 0.05882353f, 0.05882353f);
    public static Color3f green = new Color3f(0.015686275f, 0.68235296f, 0.05882353f);
    public static Color3f blue = new Color3f(0.10980392f, 0.23529412f, 0.9372549f);
    public static Color3f lightGray = new Color3f(0.6862745f, 0.6862745f, 0.6862745f);
    static float shininess = 80.0f;
    public static Material redMaterial = new Material(red, black, red, white, shininess);
    public static Material greenMaterial = new Material(green, black, green, lightGray, shininess);
    public static Material blueMaterial = new Material(blue, black, blue, lightGray, shininess);
    boolean visible = false;
    Switch switchGroup = new Switch();

    public Axes(Group group) {
        this(group, defaultRadius, defaultLength);
    }

    public Axes(Group group, float f, float f2) {
        Appearance appearance;
        this.switchGroup.setCapability(18);
        for (int i = 1; i <= 3; ++i) {
            appearance = new Appearance();
            Transform3D transform3D = new Transform3D();
            Transform3D transform3D2 = new Transform3D();
            switch (i) {
                case 1: {
                    appearance.setMaterial(redMaterial);
                    transform3D2.rotZ(Math.toRadians(-90.0));
                    break;
                }
                case 2: {
                    appearance.setMaterial(greenMaterial);
                    break;
                }
                case 3: {
                    appearance.setMaterial(blueMaterial);
                    transform3D2.rotX(Math.toRadians(90.0));
                }
            }
            transform3D.setTranslation(new Vector3f(0.0f, f2 / 2.0f, 0.0f));
            transform3D2.mul(transform3D);
            TransformGroup transformGroup = new TransformGroup(transform3D2);
            transformGroup.addChild((Node)new Cylinder(f, f2, appearance));
            this.switchGroup.addChild((Node)transformGroup);
        }
        appearance = new Appearance();
        appearance.setMaterial(new Material(black, black, white, black, shininess));
        this.switchGroup.addChild((Node)new Sphere(f, appearance));
        group.addChild((Node)this.switchGroup);
        this.setVisible(true);
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            if (!bl) {
                this.switchGroup.setWhichChild(-1);
            } else {
                this.switchGroup.setWhichChild(-2);
            }
            this.visible = bl;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }
}

