/*
 * Decompiled with CFR 0.152.
 */
package org.himinbi.j3d.test;

import com.miltec.mvis.Axes;
import com.miltec.mvis.SimpleScene;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

public class AxesTest
extends JApplet
implements ActionListener {
    Axes axes;
    JCheckBox visibleBox;

    public AxesTest() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Canvas3D canvas3D = this.createCanvas();
        gridBagLayout.setConstraints((Component)canvas3D, gridBagConstraints);
        this.getContentPane().add((Component)canvas3D);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.visibleBox = new JCheckBox("Visible", this.axes.isVisible());
        gridBagLayout.setConstraints(this.visibleBox, gridBagConstraints);
        this.getContentPane().add(this.visibleBox);
        this.visibleBox.addActionListener(this);
    }

    private Canvas3D createCanvas() {
        float f = 1.0f;
        float f2 = 0.04f;
        View view = new View();
        view.setPhysicalBody(new PhysicalBody());
        view.setPhysicalEnvironment(new PhysicalEnvironment());
        Canvas3D canvas3D = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        view.addCanvas3D(canvas3D);
        ViewPlatform viewPlatform = new ViewPlatform();
        view.attachViewPlatform(viewPlatform);
        SimpleScene simpleScene = new SimpleScene((Component)canvas3D);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(0.0f, -f / 5.0f, -f * 3.0f));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        transformGroup.setCapability(12);
        transformGroup.setCapability(13);
        transformGroup.setCapability(14);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
        MouseZoom mouseZoom = new MouseZoom(transformGroup);
        mouseZoom.setSchedulingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)mouseZoom);
        MouseRotate mouseRotate = new MouseRotate(transformGroup);
        mouseRotate.setSchedulingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)mouseRotate);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild((Node)transformGroup);
        branchGroup.addChild((Node)viewPlatform);
        this.axes = new Axes((Group)transformGroup, f2, f);
        simpleScene.getRoot().addChild((Node)branchGroup);
        simpleScene.makeLive();
        return canvas3D;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.visibleBox) {
            this.axes.setVisible(this.visibleBox.isSelected());
        }
    }

    public static void main(String[] stringArray) {
        new MainFrame((Applet)new AxesTest(), 400, 300);
    }
}

