public class Signal
{
	public static final int STATE_CHANGE = 1;
	public static final int AREA_STARTED = 2;
	public static final int AREA_STOPPED = 3;
	public static final int DESTINATION_CHANGED =  4;
	public static final int SHAPE_CHANGED = 5;
	public static final int ALL_STOPPED = 6;
	public static final int ALL_STARTED = 7;
	public static final int GENERATE_AGENTS = 8;

	public int state;
	public Object content;

	Signal(int state)
	{
		this.state = state;
	}

	public String toString()
	{
		String out;

		switch(state)
		{
			case STATE_CHANGE:
				out = "state change";
				break;
			case AREA_STARTED:
				out = "area started";
				break;
			case AREA_STOPPED:
				out = "area stopped";
				break;
			case DESTINATION_CHANGED:
				out = "destination changed";
				break;
			case SHAPE_CHANGED:
				out = "shape changed";
				break;
			case ALL_STARTED:
				out = "all started";
				break;
			case ALL_STOPPED:
				out = "all stopped";
				break;
			case GENERATE_AGENTS:
				out = "generate agents";
				break;
			default:
				out = "unknown";
				break;
		}
		return out;
	}
}