import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.awt.image.*;
import java.util.*;

public class MasterAgent extends Agent implements VirtualWorld
{
	public static int MIN_AGENTS = 10;
	public static int MAX_AGENTS = 20;

	private Rectangle bounds = new Rectangle();
	private Vector agentVector = new Vector();

	MasterAgent()
	{
		super();
	}

	public void addAgent(Agent agent)
	{
		agentVector.add(agent);
	}

	public void generateAgents()
	{
		generateAgents(MIN_AGENTS + (int)(Math.random() * MAX_AGENTS - MIN_AGENTS) + 1);
	}

	public void generateAgents(int numAgents)
	{
		for(int i = 0; i < numAgents; i++)
			addAgent(new Agent1(this, this));
	}

	public void generateAgents(Point position)
	{
		Agent1 newAgent = new Agent1(this, this);
		newAgent.moveTo(position);
		addAgent(newAgent);
	}

	public void setBounds(int width, int height)
	{
		bounds.width = width;
		bounds.height = height;
	}

	private Point point1 = new Point(150, 150);
	private Point point2 = new Point(25, 25);
	private int i = 1;
	private int loopCount = 1;

	public void paint(Graphics g)
	{
		if(g == null || g.getClipBounds() == null)
			return;

		for(int i = 0; i < agentVector.size(); i++)
			if(agentVector.elementAt(i) instanceof MovingAgent)
				((MovingAgent)agentVector.elementAt(i)).paint(g);
	}

	public void broadcast(Signal newSignal)
	{
		for(int i = 0; i < agentVector.size(); i++)
			((Agent)agentVector.elementAt(i)).signal(newSignal);
	}

	public void startAll()
	{
		Signal startSignal = new Signal(Signal.STATE_CHANGE);
		startSignal.content = new Integer(MovingAgent.MOVING);
		broadcast(startSignal);
	}

	public void stopAll()
	{
		Signal stopSignal = new Signal(Signal.STATE_CHANGE);
		stopSignal.content = new Integer(MovingAgent.STOPPED);
		broadcast(stopSignal);
	}

	public void signal(Signal s)
	{
		switch(s.state)
		{
			case Signal.DESTINATION_CHANGED:
			case Signal.AREA_STARTED:
			case Signal.AREA_STOPPED:
			case Signal.ALL_STARTED:
			case Signal.ALL_STOPPED:
				broadcast(s);
				break;
			case Signal.GENERATE_AGENTS:
				if(s.content instanceof Point)
					generateAgents((Point)s.content);
				else
					generateAgents(((Integer)s.content).intValue());
				break;
			case Signal.SHAPE_CHANGED:
				bounds.setSize((Dimension)s.content);
				break;
		}
		System.out.println("Master recieved signal " + s.toString());
	}

	public boolean contains(Shape testShape)
	{
		boolean returnValue = ShapeUtilities.isAContainedByB(testShape, bounds);
		return returnValue;
	}

	public boolean isClear(Shape shape)
	{
		return isClear(shape, null);
	}

	public boolean isClear(Shape testShape, Object tester)
	{
		boolean clear = contains(testShape);

		for(int i = 0; clear && i < agentVector.size(); i++)
			if(agentVector.elementAt(i) instanceof MovingAgent && agentVector.elementAt(i) != tester)
				clear = !((MovingAgent)agentVector.elementAt(i)).intersects(testShape);

		return clear;
	}	

	public Enumeration objectsIntersecting(Shape shape)
	{
		Vector out = new Vector();
		int i = 0;

		for(; i < agentVector.size(); i++)
			if(agentVector.elementAt(i) instanceof MovingAgent)
				if(((MovingAgent)agentVector.elementAt(i)).intersects(shape));
					out.add(agentVector.elementAt(i));

		return out.elements();
	}
		
	public Enumeration objectsContainedBy(Shape shape)
	{
		Vector out = new Vector();
		int i = 0;

		for(; i < agentVector.size(); i++)
			if(agentVector.elementAt(i) instanceof MovingAgent)
				if(shape.contains(((MovingAgent)agentVector.elementAt(i)).getShape().getBounds()));
					out.add(agentVector.elementAt(i));

		return out.elements();
	}

	public Object objectAt(Point p)
	{
		boolean found = false;
		int i = 0;

		while(!found && i < agentVector.size())
			if(agentVector.elementAt(i) instanceof MovingAgent)
			{
				if(((MovingAgent)agentVector.elementAt(i)).getShape().contains(p))
					found = true;
				else
					i++;
			}

		if(found)
			return agentVector.elementAt(i);
		else
			return null;
	}

	public Point middle()
	{
		return new Point((int)(bounds.width / 2), (int)(bounds.height / 2));
	}
}