import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.awt.image.*;

public class Agent1 extends MovingAgent
{
	public Point destination;
	public int speed;
	private Sensor sensor;

	public int MIN_SIZE = 3;
	public int MAX_SIZE = 12;
	public int MIN_SPEED = 3;
	public int MAX_SPEED = 5;

	public Agent1(Agent master, VirtualWorld world)
	{
		super(master, world);
		sensor = new Sensor(this, world);
		speed = MIN_SPEED + (int)(Math.random() * (MAX_SPEED - MIN_SPEED)) + 1;
		shape = new Polygon();
		moveTo(new Point((int)(Math.random() * 800), (int)(Math.random() * 800)));

		int size = MIN_SIZE + (int)(Math.random() * (MAX_SIZE - MIN_SIZE)) + 1;
		((Polygon)shape).addPoint(   -size, -size);
		((Polygon)shape).addPoint(    size, -size);
		((Polygon)shape).addPoint(2 * size,  0   );
		((Polygon)shape).addPoint(    size,  size);
		((Polygon)shape).addPoint(   -size,  size);

		state = FINISHED;
	}

	public void step()
	{
		if(shape == null || position == null)
			return;

		System.out.println(toString() + " stepped");

		switch(state)
		{
			case MOVING:
				if(destination != null && !position.equals(destination))
				{
					turnTo(Math.atan2(destination.y - position.y, destination.x - position.x));

					if(!sensor.hit(0))
					{
						int deltaDistance = (int)(position.distance(destination));

						if(deltaDistance > speed)
							move(new Point(speed, 0));
						else
							move(new Point(deltaDistance, 0));
					}
					else
						state = WAITING;
				}
				else
					state = FINISHED;
				break;
			case TURNING:
				state = MOVING;
				break;
			case WAITING:
				state = MOVING;
				break;
			case FINISHED:
				if(!world.contains(getShape()))
				{
					destination = world.middle();
					state = MOVING;
					setPaused(false);
				}
				else
					setPaused(true);
				break;
			case BACKTRACKING:
				state = MOVING;
				break;
			case STUCK:
				state = MOVING;
				break;
			case STOPPED:
				setPaused(true);
				break;
		}
	}

	public void signal(Signal s)
	{
		if(state == STOPPED && s.state != Signal.ALL_STARTED)
			return;		

		switch(s.state)
		{
			case Signal.DESTINATION_CHANGED:
				destination = (Point)s.content;
				state = MOVING;
				setPaused(false);
				break;
			case Signal.AREA_STOPPED:
				if(ShapeUtilities.isIntersection(getShape(), (Shape)s.content));
					state = STOPPED;
				break;
			case Signal.AREA_STARTED:
				if(ShapeUtilities.isIntersection(getShape(), (Shape)s.content));
					state = MOVING;
				break;
			case Signal.ALL_STOPPED:
				state = STOPPED;
				break;
			case Signal.ALL_STARTED:
				state = MOVING;
				break;
		}
		System.out.println("Mover " + toString() + " recieved signal " + s.toString());
	}

	public String toString()
	{
		String out;

		if(destination == null)
			out = new String(super.toString() + ": waiting at [" + position.x + "," + position.y + "]");
		else
			out = new String(super.toString() + ": moving from [" + position.x + "," + position.y + "] to [" + destination.x + ", " + destination.y + "]");

		return out;
	}
}

class Sensor
{
	VirtualWorld world;
	MovingAgent mover;
	Arc2D.Double arc = new Arc2D.Double();

	public Sensor(MovingAgent mover, VirtualWorld world)
	{
		this.world = world;
		this.mover = mover;
	}

	public boolean hit(double theta)
	{
		return false;
	}
}