import java.awt.*;

public abstract class Agent implements Runnable
{
	public long deltaTime = 200;
	private Thread steppingThread;
	private boolean threadSuspended = false;
	private boolean stepDefined = true;

	Agent()
	{
		step();
		if(stepDefined)
		{
			steppingThread = new Thread(this);
			steppingThread.start();
		}
	}

	public void paint(Graphics g) {}

	public void step()
	{
		stepDefined = false;
	}

	public void signal(Signal newSignal)
	{
		System.out.println(toString() + ": " + newSignal.toString());
	}

	public void run()
	{
		boolean interrupted = false;

		while(!interrupted)
		{
			step();
			try
			{
				steppingThread.sleep(deltaTime);

				synchronized(this)
				{
					while(threadSuspended)
						wait();
				}
			}
			catch(InterruptedException e)
			{
				interrupted = true;
			}
		}
		System.out.println("Thread dead");
	}

	public synchronized void pause()
	{
		setPaused(!threadSuspended);
	}

	public synchronized void setPaused(boolean suspended)
	{
		threadSuspended = suspended;

		if(!threadSuspended)
			notify();
	}

	public boolean getPaused() { return threadSuspended; }
}